/**********************************************************************

	--- Qt Architect generated file ---

	File: noteoverview.cpp
	Last generated: Sat Mar 2 15:23:44 2002

 *********************************************************************/


#include "noteoverview.h"
#include "kaspawidget.h"
#include "resource.h"
#include <kapp.h>
#include <qstring.h>
#include "kaspabase.h"
#include <kiconloader.h>
#include <klocale.h>
#include <qwhatsthis.h>


NoteOverview::NoteOverview(KaspaURL url, Sql *conn, const char *caption, QWidget *parent) :
	NoteOverviewData(parent), showleafs(false) {
	_url=url;
	kaspa=new KaspaBase(conn);
	ASSERT(kaspa);

  connect(notesview,   SIGNAL(executed(QListViewItem*)), this, SLOT(slotExecute(QListViewItem*)));
  connect(notesview, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)),
          this, SLOT(slotContextMenu(KListView*, QListViewItem*, const QPoint&)));
  connect(notesview, SIGNAL(moved(QListViewItem*, QListViewItem*, QListViewItem*)),
          this, SLOT(slotMoved(QListViewItem*, QListViewItem*, QListViewItem*)));

	notesview->addColumn("Notes");
	notesview->setRootIsDecorated(true);
	notesview->setItemsMovable(true);
	notesview->setDragEnabled(true);
	notesview->setItemsRenameable(false);
  notesview->setAcceptDrops(true);
  notesview->setSorting(0);
  notesview->setDropHighlighter(true);
  notesview->setDropVisualizer(false);

  pop1.insertItem(i18n("Open Item in new Window"), this, SLOT(slotOpenItemNewWin()));

  pop2.insertItem(i18n("New Item"), this, SLOT(slotNewItem()));
  pop2.insertItem(i18n("Insert Item"), this, SLOT(slotInsertItem()));
  pop2.insertItem(i18n("Open Item in new Window"), this, SLOT(slotOpenItemNewWin()));
}

NoteOverview::~NoteOverview()
{
	debug("NoteOverview::~NoteOverview()");
}

void NoteOverview::slotInsertItem() {
	try {
  	NoteTitle *notes=kaspa->getNoteTitles(_url.where());
		NoteTreeDlg dlg(notes);
		if(dlg.exec()) {
			if(dlg.getOid()==InvalidOid) return;
      Oid o=dlg.getOid();
      NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
      if(!i) return;

      QListViewItemIterator it( notesview );
      for ( ; it.current(); ++it ) {
        NoteTreeItem *nt=dynamic_cast<NoteTreeItem*>(it.current());
        if(nt && nt->oid==o) {
          notesview->moveItem(nt, i, 0L);
          break;
        }
      }
     kaspa->moveNote(o, i->oid, 0L);
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

/*
void NoteOverview::slotItemUp() {
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
  if(!i) return;
  NoteTreeItem *p=dynamic_cast<NoteTreeItem*>(i->parent());
  NoteTreeItem *sibling=dynamic_cast<NoteTreeItem*>(notesview->itemAtIndex(notesview->itemIndex(i)-2));
  notesview->moveItem(i, p, sibling);

  kaspa->moveNote(i->oid, p?p->oid:0, sibling?sibling->oid:0);
}

void NoteOverview::slotItemDown() {
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
  if(!i) return;
  if(notesview->lastItem()==i) return;
  NoteTreeItem *p=dynamic_cast<NoteTreeItem*>(i->parent());
  NoteTreeItem *sibling=dynamic_cast<NoteTreeItem*>(notesview->itemAtIndex(notesview->itemIndex(i)+1));
  notesview->moveItem(i, p, sibling);

  kaspa->moveNote(i->oid, p?p->oid:0, sibling?sibling->oid:0);
}

void NoteOverview::slotItemLeft() {
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
  if(!i) return;
  NoteTreeItem *p=dynamic_cast<NoteTreeItem*>(i->parent());
  if(!p) return;
  notesview->moveItem(i, p->parent(), p);

  NoteTreeItem *sp=dynamic_cast<NoteTreeItem*>(p->parent());
  kaspa->moveNote(i->oid, sp?sp->oid:0, p?p->oid:0);
}

void NoteOverview::slotItemRight() {
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
  if(i) notesview->moveItem(i, notesview->itemAtIndex(notesview->itemIndex(i)-1), 0L);

  NoteTreeItem *p=dynamic_cast<NoteTreeItem*>(notesview->itemAtIndex(notesview->itemIndex(i)-1));
  kaspa->moveNote(i->oid, p?p->oid:0, 0L);
}
*/

void NoteOverview::slotMoved(QListViewItem *item, QListViewItem *afterFirst, QListViewItem *afterNow) {
  if(!item) return;
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(item);
  NoteTreeItem *p=dynamic_cast<NoteTreeItem*>(item->parent());
  kaspa->moveNote(i->oid, p?p->oid:0L, 0L);
  if(!p) return;
  notesview->sort();
}

void NoteOverview::slotNewItem() {
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
  if(!i) return;
  Oid n=kaspa->newNote(InvalidOid);
  kaspa->moveNote(n, i->oid, 0L);
  requestNote(n);
}

void NoteOverview::slotOpenItemNewWin() {
  NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(notesview->currentItem());
  if(!i) return;
  requestNote(i->oid, true);
}

void NoteOverview::slotExecute(QListViewItem *i) {
  NoteTreeItem *item=dynamic_cast<NoteTreeItem*>(i);
  if(!item) return;
  requestNote(item->oid, false);
}

void NoteOverview::slotContextMenu(KListView* l, QListViewItem* i, const QPoint& p) {
  NoteTreeItem *it=dynamic_cast<NoteTreeItem*>(i);
  if(!it) return;
  if(it->publnote)
    pop1.popup(QCursor::pos());
  else
    pop2.popup(QCursor::pos());
}

void NoteOverview::addItem(NoteTitle *notes, Oid parentoid, NoteTreeItem *parentitem) {
  for(NoteTitle *nextnote=notes; nextnote; nextnote=nextnote->getNext())
  {
    if(nextnote->getParent()==parentoid) {
      Title *leafs=0L;

//        leafs=kaspa->getLinks(nextnote->getOid());

      NoteTreeItem *knot;
      if(parentitem)
  		  knot=new NoteTreeItem(parentitem, nextnote->getOid(), nextnote->getTitle(), BarIcon("shownote.png"), false);
      else
  		  knot=new NoteTreeItem(notesview, nextnote->getOid(), nextnote->getTitle(), BarIcon("shownote.png"), false);
      addItem(notes, nextnote->getOid(), knot);

      if(showleafs) {
        leafs=kaspa->getNoteTitles(QString("where note.no=link.obj_1 and link.obj_2=")+QString().number(nextnote->getOid()) );
        for(Title *next=leafs; next; next=next->getNext())
          new NoteTreeItem(knot, next->getOid(), next->getTitle(), BarIcon("showpubl.png"), true);

        leafs=kaspa->getNoteTitles(QString("where note.no=link.obj_2 and link.obj_1=")+QString().number(nextnote->getOid()) );
        for(Title *next=leafs; next; next=next->getNext())
          new NoteTreeItem(knot, next->getOid(), next->getTitle(), BarIcon("showpubl.png"), true);
        kapp->processEvents();
     }
    }
  }
}

void NoteOverview::setup()
{
	NoteTitle *notes=kaspa->getNoteTitles(_url.where());
	// For all publications

  addItem(notes, 0, 0L);
	notesview->geometry();
}

bool NoteOverview::isWorking() {
	try {
		return kaspa->isWorking();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return true;
	}
}

bool NoteOverview::isValid() {
	return true;
}

void NoteOverview::reread() {
  setFields();
}

void NoteOverview::setFields() {
  notesview->clear();
  if(isValid()) {
		setWorkingGUI();
	  setup();
	}
	setupGUI();
}

void NoteOverview::setInvalidGUI() {
  emit enableCommand(ID_NOTEOVERVIEW_RESET);
  emit enableCommand(ID_NOTEOVERVIEW_SHOWPUBL);
	NoteOverviewData::setInvalidGUI();
	lockGUI();
}	

void NoteOverview::setReadWriteGUI() {
  emit enableCommand(ID_NOTEOVERVIEW_RESET);
  emit enableCommand(ID_NOTEOVERVIEW_SHOWPUBL);
 	NoteOverviewData::setReadWriteGUI();
 	unlockGUI();
}

void NoteOverview::setWorkingGUI() {
  emit disableCommand(ID_NOTEOVERVIEW_RESET);
  emit disableCommand(ID_NOTEOVERVIEW_SHOWPUBL);
	NoteOverviewData::setWorkingGUI();
	lockGUI();
}

void NoteOverview::setReadOnlyGUI() {
  emit enableCommand(ID_NOTEOVERVIEW_RESET);
  emit enableCommand(ID_NOTEOVERVIEW_SHOWPUBL);
	NoteOverviewData::setReadOnlyGUI();
	unlockGUI();
}


bool NoteOverview::closeRequest() {
  return true;
}

void NoteOverview::showPublication() {
  showleafs=!showleafs;
  setFields();
}

KToolBar *NoteOverview::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("reload.xpm"), ID_NOTEOVERVIEW_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert") );
  int id=toolbar->insertButton(BarIcon("showpubl.xpm"), ID_NOTEOVERVIEW_SHOWPUBL, SIGNAL(clicked()),
				this, SLOT(showPublication()), true, i18n("Show Publication Notes") );
  toolbar->setToggle(id);
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}
