/***************************************************************************
                          editor.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef Editor_included
#define Editor_included

#include <qobject.h>
#include <qtextedit.h>
#include <kaspawidget.h>

class QAction;
class QComboBox;
class QToolBar;
class QString;
class QFont;
class QColor;

class MyTextEdit : public QTextEdit
{
 Q_OBJECT

private:
	MyTextEdit(const MyTextEdit&);
	MyTextEdit& operator=(const MyTextEdit&);

private slots:
  void slotReturnPressed();
	
public:
  MyTextEdit(QWidget * parent=0, const char * name=0);
  QString text() const;
};

class Editor: public KaspaWidget
{
    Q_OBJECT


private:
	Editor(const Editor&);
	Editor& operator=(const Editor&);
	
public:
  Editor(QWidget * parent=0, const char * name=0, WFlags f=0 );

private:
    QAction *actionTextBold,
            *actionTextUnderline,
            *actionTextItalic,
            *actionTextColor,
            *actionAlignLeft,
            *actionAlignCenter,
            *actionAlignRight,
            *actionAlignJustify;
    QComboBox *comboStyle,
              *comboFont,
              *comboSize;

public:
    MyTextEdit *memo;

public slots:
    void setupToolbar(QToolBar *toolbar);
    void setupEditorConnections();

private slots:
    void editUndo();
    void editRedo();
    void editCut();
    void editCopy();
    void editPaste();

    void textBold();
    void textUnderline();
    void textItalic();
    void textFamily( const QString &f );
    void textSize( const QString &p );
    void textStyle( int s );
    void textColor();
    void textAlign( QAction *a );

    void fontChanged( const QFont &f );
    void colorChanged( const QColor &c );
    void alignmentChanged( int a );

};
#endif








