/***************************************************************************
                          bibtexfactory.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jul 28 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "bibtexfactory.h"

BibTexFactory::BibTexFactory(){
}
BibTexFactory::~BibTexFactory(){
}

QString &BibTexFactory::article(QString entry, QString author, QString title, QString journal, QString year, QString volume,
						 									  QString number, QString pages, QString month, QString note, QString key, QString crossref)
{
	bt="@ARTICLE{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!journal.isEmpty()) addJournal(journal);
	if(!year.isEmpty()) addYear(year);
	if(!volume.isEmpty()) addVolume(volume);
	if(!number.isEmpty()) addNumber(number);
	if(!pages.isEmpty())	addPages(pages);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	if(!key.isEmpty()) addKey(key);
	if(!crossref.isEmpty()) addCrossRef(crossref);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::book(QString entry, QString author, QString editor, QString title, QString publisher, QString year,
														 QString volume, QString number, QString series,QString address, QString edition,
														 QString month,	QString note) {
	bt="@BOOK{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!editor.isEmpty()) addEditor(editor);
	if(!title.isEmpty()) addTitle(title);
	if(!publisher.isEmpty()) addPublisher(publisher);
	if(!year.isEmpty()) addYear(year);
	if(!volume.isEmpty()) addVolume(volume);
	if(!number.isEmpty()) addNumber(number);
	if(!series.isEmpty()) addSeries(series);
	if(!address.isEmpty()) addAddress(address);
	if(!edition.isEmpty()) addEdition(edition);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::booklet(QString entry, QString title, QString author, QString howpublished, QString address, QString month,
															  QString year, QString note) {
	bt="@BOOKLET{"+entry;
	if(!title.isEmpty()) addTitle(title);
	if(!author.isEmpty()) addAuthor(author);
	if(!howpublished.isEmpty()) addHowpublished(howpublished);
	if(!address.isEmpty()) addAddress(address);
	if(!month.isEmpty()) addMonth(month);
	if(!year.isEmpty()) addYear(year);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::inbook(QString entry, QString author, QString editor, QString title, QString chapter, QString pages, QString publisher,
															 QString year, QString volume, QString number, QString series, QString type, QString address,
															 QString edition, QString month, QString note, QString key, QString crossref) {
	bt="@INBOOK{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!editor.isEmpty()) addEditor(editor);
	if(!title.isEmpty()) addTitle(title);
	if(!chapter.isEmpty()) addChapter(chapter);
	if(!pages.isEmpty()) addPages(pages);
	if(!publisher.isEmpty()) addPublisher(publisher);
	if(!year.isEmpty()) addYear(year);
	if(!volume.isEmpty()) addVolume(volume);
	if(!number.isEmpty()) addNumber(number);
	if(!series.isEmpty()) addSeries(series);
	if(!type.isEmpty()) addType(type);
	if(!address.isEmpty()) addAddress(address);
	if(!edition.isEmpty()) addEdition(edition);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	if(!key.isEmpty()) addKey(key);
	if(!crossref.isEmpty()) addCrossRef(crossref);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::incollection(QString entry, QString author, QString title, QString booktitle, QString publisher, QString year,
																		 QString editor, QString volume, QString number, QString series, QString type,
																		 QString chapter, QString pages, QString address, QString edition, QString month,
																		 QString note, QString key, QString crossref) {
	bt="@INCOLLECTION{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!booktitle.isEmpty()) addBooktitle(booktitle);
	if(!publisher.isEmpty()) addPublisher(publisher);
	if(!year.isEmpty()) addYear(year);
	if(!editor.isEmpty()) addEditor(editor);
	if(!volume.isEmpty()) addVolume(volume);
	if(!number.isEmpty()) addNumber(number);
	if(!series.isEmpty()) addSeries(series);
	if(!type.isEmpty()) addType(type);
	if(!chapter.isEmpty()) addChapter(chapter);
	if(!pages.isEmpty()) addPages(pages);
	if(!address.isEmpty()) addAddress(address);
	if(!edition.isEmpty()) addEdition(edition);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	if(!key.isEmpty()) addKey(key);
	if(!crossref.isEmpty()) addCrossRef(crossref);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::inproceedings(QString entry, QString author, QString title, QString booktitle, QString year, QString editor, QString volume,
																			QString number, QString series, QString pages, QString address, QString month,
																			QString organization, QString publisher, QString note, QString key, QString crossref) {
	bt="@INPROCEEDINGS{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!booktitle.isEmpty()) addBooktitle(booktitle);
	if(!year.isEmpty()) addYear(year);
	if(!editor.isEmpty()) addEditor(editor);
	if(!volume.isEmpty()) addVolume(volume);
	if(!number.isEmpty()) addNumber(number);
	if(!series.isEmpty()) addSeries(series);
	if(!pages.isEmpty()) addPages(pages);
	if(!address.isEmpty()) addAddress(address);
	if(!month.isEmpty()) addMonth(month);
	if(!organization.isEmpty()) addOrganization(organization);
	if(!publisher.isEmpty()) addPublisher(publisher);
	if(!note.isEmpty()) addNote(note);
	if(!key.isEmpty()) addKey(key);
	if(!crossref.isEmpty()) addCrossRef(crossref);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::manual(QString entry, QString title, QString author, QString organization, QString address, QString edition,
															 QString month, QString year, QString note) {
	bt="@MANUAL{"+entry;
	if(!title.isEmpty()) addTitle(title);
	if(!author.isEmpty()) addAuthor(author);
	if(!organization.isEmpty()) addOrganization(organization);
	if(!address.isEmpty()) addAddress(address);
	if(!edition.isEmpty()) addEdition(edition);
	if(!month.isEmpty()) addMonth(month);
	if(!year.isEmpty()) addYear(year);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::masterthesis(QString entry, QString author, QString title,	QString school,	QString year,
																		 QString type, QString address, QString month, QString note) {
	bt="@MASTERSTHESIS{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!school.isEmpty()) addSchool(school);
	if(!year.isEmpty()) addYear(year);
	if(!type.isEmpty()) addType(type);
	if(!address.isEmpty()) addAddress(address);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::misc(QString entry, QString author, QString title, QString howpublished,
														 QString month, QString year, QString note) {
	bt="@MISC{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!howpublished.isEmpty()) addHowpublished(howpublished);
	if(!month.isEmpty()) addMonth(month);
	if(!year.isEmpty()) addYear(year);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::phdthesis(QString entry, QString author, QString title, QString school, QString year, QString type,
																  QString address, QString month, QString note) {
	bt="@PHDTHESIS{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!school.isEmpty()) addSchool(school);
	if(!year.isEmpty()) addYear(year);
	if(!type.isEmpty()) addType(type);
	if(!address.isEmpty()) addAddress(address);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::proceedings(QString entry, QString title, QString year, QString editor, QString volume, QString number,
																		QString series, QString address, QString month, QString organization,
																		QString publisher, QString note) {
	bt="@PROCEEDINGS{"+entry;
	if(!title.isEmpty()) addTitle(title);
	if(!year.isEmpty()) addYear(year);
	if(!editor.isEmpty()) addEditor(editor);
	if(!volume.isEmpty()) addVolume(volume);
	if(!number.isEmpty()) addNumber(number);
	if(!series.isEmpty()) addSeries(series);
	if(!address.isEmpty()) addAddress(address);
	if(!month.isEmpty()) addMonth(month);
	if(!organization.isEmpty()) addOrganization(organization);
	if(!publisher.isEmpty()) addPublisher(publisher);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::techreport(QString entry, QString author, QString title, QString institution, QString year, QString address,
																	 QString type, QString number, QString month,	QString note) {
	bt="@TECHREPORT{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!institution.isEmpty()) addInstitution(institution);
	if(!year.isEmpty()) addYear(year);
	if(!address.isEmpty()) addAddress(address);
	if(!type.isEmpty()) addType(type);
	if(!number.isEmpty()) addNumber(number);
	if(!month.isEmpty()) addMonth(month);
	if(!note.isEmpty()) addNote(note);
	bt+="\n}\n";
	return bt;
}

QString &BibTexFactory::unpublished(QString entry, QString author, QString title, QString note, QString month, QString year) {
	bt="@UNPUBLISHED{"+entry;
	if(!author.isEmpty()) addAuthor(author);
	if(!title.isEmpty()) addTitle(title);
	if(!note.isEmpty()) addNote(note);
	if(!month.isEmpty()) addMonth(month);
	if(!year.isEmpty()) addYear(year);
	bt+="\n}\n";
	return bt;
}











