/***************************************************************************
                          partbase.h  -  description                              
                             -------------------                                         
    begin                : Sun Sep 26 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PARTBASE_H
#define PARTBASE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <kaspabase.h>
#include "table.h"
/**
  *@part Jan Mueller
  */

class PartBase : public Table  {
	private:
  PartBase(const PartBase&);
	PartBase& operator=(const PartBase&);	

	public:
  /** Create new part. The fields are empty. The connection is initialized from
   *  an established connection (sharing) or the database with name dbname is opened
   *  Throws exceptions.
   */
  PartBase(Oid publ, Sql *conn);
  PartBase(Oid publ, const char *dbname);

  /** Reads row with the sql where clause where. It
   *  must not return more than one record. See above
   *  for connection parameters.
   *  Throws exceptions.
   */
  PartBase(const char *where, Sql *conn);
  PartBase(const char *where, const char *dbname);

  /** Destructor.
   *  Throws exceptions.
	 */
	 virtual ~PartBase() throw();

  /** returns pointer to lastname, pointers are valid until deletion,
   * reset or destruction of the instance. The strings are guaranteed to
   * be not 0L. If the tuple is invalied (e.g. deleted) the strings are
   * empty ("").
   * Does not throw exceptions.
   */
  const char *getTitle();
  const char *getPages();
  const char *getLanguage();
  const char *getMemo();
	const char *getBibTex();
	bool  getCreateBibTex();
  const char *getKey();
	int		getNumber();
  Oid   getFirstFile();
  PublTitle *getPartPubl();
  AuthorName *getPartAuthors();
  PartDataName *getFiles();
	const char *getModified();
	const char *getCreated();

  /** Sets the field lastname and mark it as changed. The string is copied.
   * Does not throw exceptions.
   */
  void setTitle(const char *s);
  void setPages(const char *s);
  void setLanguage(const char *s);
  void setMemo(const char *d);
	void setBibTex(const char *bibtex);
	void setCreateBibTex(bool b);
  void setKey(const char *d);
	void setNumber(const char *s);
  void setFirstFile(Oid o);
  void setPubl(Oid o);
	
/*	char 	 *readFile(Oid o, long *len);
	char	 *readFile(char *name, long *len); */
	void		deleteFile(Oid o);
	void		deleteFile(const char *name);

	Oid createNote();
	Oid createAuthor();
	void insertAuthor(Oid o);
	void removeAuthor(Oid o);
	NoteTitle *getNotes();

  /** returns a pointer to the where clause matching the tuple.
   * Does not throw exceptions.
   */
  /**  */
  int bibTexIndex(Oid author, const char *year, Oid publ);
  virtual const char *getWhereClause() { return _where; }

  void moveAuthorUp(Oid author) { KaspaBase::movePartAuthorUp(author, part()->id.get()); }
  void moveAuthorDown(Oid author) { KaspaBase::movePartAuthorDown(author, part()->id.get()); }

 private:
  /** Implemantation of pure virtual method @ref Table::read.
      It tries to read the part matching the where clause.
      If the part does not exist, the fields are emptied and
      the tuple is marked as invalid.
      Throws exceptions.
  */
  virtual KaspaRec *invalid();
  virtual KaspaRec *read(const char *where);
  /** Implementation of pure virtual method from @ref Table.
      It updates the fields marked changed. These fields marked
      as unchanged again.
      Throws exceptions.
  */
  virtual void write(const char *where, bool block=false);
  /** Implementation of the pure virtual method @ref Table::del.
      It deletes the tuple, empties all fields and set invalid state.
      Throws exceptions.
  */
  virtual void del(const Oid o);
  /** casts @ref Table::rec (of type @ref KaspaRec) to type @ref PartRec
      Does not throw exceptions.
   */
  PartRec *part();
  /** Called by constructors...  throw exceptions.*/
  void initNew(Oid publ);
  void initWhere(const char *where);	

  Str _where;

};

#endif

























