/***************************************************************************
                          kliste.h  -  description
                             -------------------
    begin                : Die Aug 17 03:44:15 CEST 1999

    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KLISTE_H
#define KLISTE_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// include files for KDE
#include <kapp.h>
#include <kparts/mainwindow.h>
#include <kaccel.h>
#include "resource.h"
#include "kaspasql.h"
#include <qstring.h>
#include "qkaspaevent.h"
#include <ktoolbar.h>
#include <kprocess.h>
#include <qdatetime.h>
#include <kcombobox.h>
#include <kaction.h>

class KaspaWidget;


class KaspaComboAction : public KAction
{
  Q_OBJECT
public:
    KaspaComboAction( const QString& text, int accel,
                      const QObject *act_recv, const char *act_slot,
                      const QObject *txt_snd, const char *txt_sig,
                      const QObject *his_snd, const char *his_sig,
                      QObject* parent, const char* name );
    ~KaspaComboAction();

    virtual int plug( QWidget *w, int index = -1 );
    virtual void unplug( QWidget *w );
    QComboBox *getCombo() { return combo; }

signals:
    void plugged();

public slots:
void slotAddHistory(const QString& s);

private:
    QComboBox *combo;
    const QObject *act_receiver;
    const char *  act_member;
    const QObject *txt_sender;
    const char *  txt_member;
    const QObject *his_sender;
    const char *  his_member;

};


/**
 * The base class for Kaspaliste application windows. It sets up the main
 * window and reads the config file as well as providing a menubar, toolbar
 * and statusbar.
 * KaspalisteApp reimplements the methods that KMainWindow provides for main window handling and supports
 * full session management as well as keyboard accelerator configuration by using KAccel.
 * @see KMainWindow
 * @see KApplication
 * @see KConfig
 * @see KAccel
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
// class KaspalisteApp : public KMainWindow
class KaspalisteApp : public KParts::MainWindow
//class KaspalisteApp : public KoMainWindow
{
  Q_OBJECT

private:
	KaspalisteApp(const KaspalisteApp&);
	KaspalisteApp& operator=(const KaspalisteApp&);
	
	
  KAction *actCopy;
	KAction *actCut;
	KAction *actPaste;
	KAction *actClose;
	KAction *actQuit;
	KAction *actCreateBibTex;
	KAction *actExport;
	KAction *actAuthorOverview;
	KAction *actNoteOverview;
	KAction *actPublOverview;
	KAction *actPublisherOverview;
	KAction *actJournalOverview;
	KAction *actNewAuthor;
	KAction *actNewNote;
	KAction *actNewPublication;
	KAction *actNewPublisher;
	KAction *actNewJournal;	
	KAction *actSearch;
	KAction *actState;
	KAction *actOptionBackground;
	KAction *actNewWindow;
  KAction *actOptionMimeTypes;
	KToggleAction *actNavToolBar;
	KToggleAction *actMainToolBar;
	KToggleAction *actStatusBar;
	KAction *actBack;
	KAction *actForward;
  KAction *actOptionKeys;
  KAction *actOptionToolbar;
  KAction *actRebuildText;
  KaspaComboAction *actURLCombo;

public:
  /** construtor of KaspalisteApp, calls all init functions to create the application.
   * @see initMenuBar initToolBar
   */
  KaspalisteApp();
  KaspalisteApp(QKaspaEvent *e);

  ~KaspalisteApp();

 protected:
  virtual bool event(QEvent *e);
  void kaspaConnections(KaspaWidget *w);
	void init();
	void setupView(const QPixmap &pm);
	bool cleanupView();

  /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
   * file
   */ 	
  void saveOptions();
  /** read general Options again and initialize all variables like the recent file list
   */
  void readOptions();
  /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
   * @see KAccel
   */
	void initBackForward();

  //void initKeyAccel();
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
   * @see KApplication#getHelpMenu
   */
  void initAction();
  /** this creates the toolbars.
   */
  void initToolBar();
  /** sets up the statusbar for the main window by initialzing a statuslabel.
   */
  void initStatusBar();

  /** queryClose is called by KMainWindow on each closeEvent of a window. Against the
   * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
   * be saved if Modified; on cancel the closeEvent is rejected.
   * @see KMainWindow#queryClose
   * @see KMainWindow#closeEvent
   */
  virtual bool queryClose();
  /** queryExit is called by KMainWindow when the last window of the application is going to be closed during the closeEvent().
   * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
   * properties.
   * @see KMainWindow#queryExit
   * @see KMainWindow#closeEvent
   */
  virtual bool queryExit();
  /** saves the window properties for each open window during session end to the session config file, including saving the currently
   * opened file by a temporary filename provided by KApplication.
   * @see KMainWindow#saveProperties
   */
  virtual void saveProperties(KConfig* );
  /** reads the session config file and restores the application's state including the last opened files and documents by reading the
   * temporary files saved by saveProperties()
   * @see KMainWindow#readProperties
   */
  virtual void readProperties(KConfig* );

  bool showAuthor(KaspaURL url);
  bool showNote(KaspaURL url);
  bool showAuthorOverview(KaspaURL url, const char *caption=0L);
  bool showNoteOverview(KaspaURL url, const char *caption=0L);
  bool showPublOverview(KaspaURL url, const char *caption=0L);
  bool showPublisherOverview(KaspaURL url, const char *caption=0L);
  bool showJournalOverview(KaspaURL url, const char *caption=0L);
  bool showPublication(KaspaURL url);
  bool showPart(KaspaURL url);
  bool showPartMemo(KaspaURL url);
  bool showBibliography(KaspaURL url);
	bool showPublisher(KaspaURL url);
	bool showJournal(KaspaURL url);
	bool showDataView(KaspaURL url);
	bool showSearch(KaspaURL url);
	bool showState(KaspaURL url);

	void setupBackForward();

  public slots:
  void slotAuthorOverview();
  void slotNoteOverview();
  void slotPublOverview();
  void slotPublisherOverview();
  void slotJournalOverview();
  void slotNewNote();
  void slotNewPublication();
  void slotNewAuthor();
  void slotNewPublisher();
  void slotNewJournal();	
  void slotSearch();
  void slotState();
	
	void slotCreateBibTex();
	void slotExport();
  void slotMimeTypes();
	void slotNextFocus();
	void slotSetURL(const char *url, bool newwin, const char *caption);
	void slotSetURL(const char *url, bool newwin);	

  /** enables menuentries/toolbar items */
  void slotEnableCommand(int id_);
  /** disables menuentries/toolbar items */
  void slotDisableCommand(int id_);
  void slotEnableCommand(int id_, bool state) { if(state) slotEnableCommand(id_); else slotDisableCommand(id_); }

  void slotBack();
  void slotForward();

	void slotChooseBackground();
  /** opens new window */
  void slotNewWindow();
  /** flushes record to database */
  void slotClose();
  /** print the actual file */
  void slotPrint();
  /** put the marked text/object into the clipboard and remove
   *	it from the document
   */
  void slotEditCut();
  /** put the marked text/object into the clipboard
   */
  void slotEditCopy();
  /** paste the clipboard into the document
   */
  void slotEditPaste();
  /** toggles the toolbar
   */
  void slotViewToolBar(QString tb);
  void slotViewNavToolBar();
  void slotViewMainToolBar();
  /** toggles the statusbar
   */
  void slotViewStatusBar();
  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
   * @param text the text that is displayed in the statusbar
   */
  void slotStatusMsg(const char *text);
  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
		* statusbar messages that give information about actions for toolbar icons and menuentries.
		* @param text the text that is displayed in the statusbar
		*/
  void slotStatusHelpMsg(const char *text);

  void slotInvalidGUI();
  void slotWorkingGUI();
  void slotReadOnlyGUI();
  void slotReadWriteGUI();
	void slotSetToolbarURL(const QString& url);

  void slotConfigureKeys();
  void slotConfigureToolbar();

  void slotRebuildText();
  void slotNewToolbarConfig();
  void slotCreateGUI(KParts::Part *part);

signals:
  void setURLText(const QString&);
  void addURL(const QString&);

 private:
	void setupWallpapers();

  /** the configuration object of the application */
  KConfig* config;
  /** the key accelerator container */
  KAccel* key_accel;

  /** view is the main widget which represents your working area. The View
   * class should handle all events of the view widget.  It is kept empty so
   * you can create your view according to your application's needs by
   * changing the view class. */
  KaspaWidget *view;
  QList<QKaspaEvent> forward;
  QList<QKaspaEvent> back;
  Sql *conn;
	KToolBar *currenttools;
	QMainWindow::ToolBarDock tbdock;

	QPixmap authorbackgr;
	QPixmap partbackgr;
	QPixmap partmemobackgr;
	QPixmap publbackgr;
	QPixmap bibliobackgr;
	QPixmap htmlbackgr;
	QPixmap notebackgr;
	QPixmap selbackgr;
	QPixmap publisherbackgr;
	QPixmap statebackgr;
	QPixmap searchbackgr;
	QPixmap editpartdatabackgr;

	QString authorbackgrpath;
	QString partbackgrpath;
	QString partmemobackgrpath;
	QString publbackgrpath;
	QString bibliobackgrpath;
	QString htmlbackgrpath;
	QString notebackgrpath;
	QString selbackgrpath;
	QString publisherbackgrpath;
	QString searchbackgrpath;

};

#endif // KLISTE_H
