CREATE TABLE author (
  no        serial,
	lastname	text 			DEFAULT '',
	firstname	text 			DEFAULT '',
	pseudonym	text 			DEFAULT '',
	born			text 			DEFAULT '',
	died	    text 			DEFAULT '',
	country		text			DEFAULT '',
	memo			text 			DEFAULT '',
	created		timestamp DEFAULT CURRENT_TIMESTAMP,
	modified	timestamp DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX author_no_index ON author (no);

CREATE TABLE part (
  no              serial,
	publication_no	int4 			DEFAULT 0,
  partno          int2      DEFAULT 1,
	title     		  text 			DEFAULT '',
	pages     		  text			DEFAULT '',
	memo   				  text 			DEFAULT '',
	key       		  text 			DEFAULT '',
	language			  text 			DEFAULT '',
	bibtex	  		  text 			DEFAULT '',
	intro_no   		  int4 			DEFAULT 0,
	createbibtex	  bool 			DEFAULT false,
	created				  timestamp DEFAULT CURRENT_TIMESTAMP,
	modified			  timestamp DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX part_publication_no_index ON part (publication_no);
CREATE INDEX part_no_index ON part (no);


CREATE TABLE partdata (
  no        serial,
	part_no	  int4 			DEFAULT 0,
	file			text 			DEFAULT '',
  astext    text      DEFAULT '',
	filename	text 			DEFAULT '',
	type     	text 			DEFAULT '',
	created		timestamp DEFAULT CURRENT_TIMESTAMP,
	modified	timestamp DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX partdata_no_index ON partdata (no);
CREATE INDEX partdata_part_no_index ON partdata (part_no);

CREATE TABLE publisher (
  no          serial,
  name				text 				DEFAULT '',
  city				text 				DEFAULT '',
	serie	    	text 				DEFAULT '',
	created			timestamp 	DEFAULT CURRENT_TIMESTAMP,
	modified		timestamp 	DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE publication (
  no          	  serial,
	title			 	 		text 			DEFAULT '',
	subtitle			 	text 			DEFAULT '',
	edition				 	int2 			DEFAULT 0,
	editor  	     	text 			DEFAULT '',
	howpublished 		text 			DEFAULT '',
	organization 		text 			DEFAULT '',
	publisher_no 		int4			DEFAULT 0,
	year      	 		text 			DEFAULT '',
	pages  			 		text 			DEFAULT '',
	translator		 	text 			DEFAULT '',
	volume				 	text 			DEFAULT '',
	number 	 			 	text 			DEFAULT '',
	month   		 		text 			DEFAULT '',
	series  			 	text 			DEFAULT '',
	type    			 	text 			DEFAULT '',
	key     			 	text 			DEFAULT '',
	orgtitle		 	  text 			DEFAULT '',
	orgpublisher_no int4			DEFAULT 0,
	orgyear		     	text 			DEFAULT '',
	isbn_issn			 	text 			DEFAULT '',
	hidingplace 	 	text 			DEFAULT '',
	bibtex			 		text 			DEFAULT '',
	entrytype			 	int2 			DEFAULT 0,
	memo   				 	text			DEFAULT 0,
	createbibtex	 	bool 			DEFAULT false,
	created		 	 		timestamp	DEFAULT CURRENT_TIMESTAMP,
	modified			 	timestamp	DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX publication_no_index ON publication (no);

CREATE TABLE publication_author (
	publication_no	int4 			DEFAULT 0,
	author_no	 			int4 			DEFAULT 0,
  author_order    int4      DEFAULT 0,
	created				  timestamp DEFAULT CURRENT_TIMESTAMP,
	modified			  timestamp DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX publication_author_author_no_index ON publication_author (author_no);
CREATE INDEX publication_author_book_no_index ON publication_author (publication_no);

CREATE TABLE part_author (
	part_no					int4 			DEFAULT 0,
	author_no				int4 			DEFAULT 0,
  author_order    int4      DEFAULT 0,
	created					timestamp DEFAULT CURRENT_TIMESTAMP,
	modified				timestamp DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX part_author_author_no ON part_author (author_no);
CREATE INDEX part_author_part_no ON part_author (part_no);


CREATE TABLE note (
  no             serial,
	title					 text 			DEFAULT '',
	memo					 text 			DEFAULT 0,
	type					 int2 			DEFAULT 0,
	publication_no int4 			DEFAULT 0,
	created				 timestamp DEFAULT CURRENT_TIMESTAMP,
	modified			 timestamp DEFAULT CURRENT_TIMESTAMP
);
CREATE INDEX note_no_index ON note (no);
CREATE INDEX note_publication_no_index ON note (publication_no);

CREATE TABLE link (
	obj_1		int4 				DEFAULT 0,
	obj_2		int4 				DEFAULT 0,
	tbl			text			 	DEFAULT '',
	created		timestamp DEFAULT CURRENT_TIMESTAMP,
	modified	timestamp DEFAULT CURRENT_TIMESTAMP
);
