/**
 * kconfigcreator.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "kconfigcreator.h"

#include "entrytoken.h"
#include "grouptoken.h"
#include "applicationtoken.h"
#include "hosttoken.h"

#include <kdebug.h>

#include <qdatastream.h>
#include <qcstring.h>
#include <qptrlist.h>

namespace KCfgCreator
{

KConfigCreator::KConfigCreator( QObject* parent )
    : CreatorInterface( parent )
{
}

void
KConfigCreator::createConfig( ApplicationToken* token )
{
    QString data;
    QTextStream stream( &data, IO_WriteOnly );
    QPtrList<GroupToken> groups = token->groupList();
    QPtrListIterator<GroupToken> itr( groups );

    if ( token->immutable() )
        stream << "[$i]\n";

    while ( itr.current() ) {
        stream << "[" << itr.current()->name() << "]";
        if ( itr.current()->immutable() )
            stream << "[$i]";
        stream << "\n";
        QPtrList<EntryToken> entries( itr.current()->entryList() );
        QPtrListIterator<EntryToken> eitr( entries );
        while ( eitr.current() ) {
            EntryToken *entry = eitr.current();
            stream << entry->key();
            if ( entry->immutable() || entry->fromEnvironment() ) {
                stream << "[$";
                if ( entry->immutable() )
                    stream << "i";
                if ( entry->fromEnvironment() )
                    stream << "e";
                stream << "]";
            }

            stream << "=" << eitr.current()->valueAsString()
                   << "\n";
            ++eitr;
        }
        ++itr;
        if ( itr.current() )
            stream << "\n";
    }

    emit done( token, data.utf8() );
}

}

#include "kconfigcreator.moc"
