/**
 * downloader.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_DOWNLOADER_H
#define KONFIG_DOWNLOADER_H

#include "hostdata.h"

#include <kio/global.h>

#include <qobject.h>
#include <qptrdict.h>
#include <qintdict.h>
#include <qstring.h>

namespace KIO {
    class Job;
    class SimpleJob;
}
class KURL;

namespace KCfgCreator
{
    class Downloader : public QObject
    {
        Q_OBJECT
    public:
        Downloader( QObject* parent, const char* name=0 );

        bool inProgress() const;

        /**
         *
         */
        virtual void get( const QString& host = QString::null,
                          const QString& user = QString::null,
                          const QString& pass = QString::null );

    signals:
        void done( HostData* );

    protected slots:
        void slotEntries( KIO::Job*, const KIO::UDSEntryList& );
        void slotSlaveConnected();
        void slotSlaveError();
        void slotData( long , const QByteArray& );
        void slotResult( long );
        void slotListResult( KIO::Job* job );
        void slotDone( HostData* hdata );

    protected:
        void getLocal();
        void getFish( const QString& host, const QString& user = QString::null,
                      const QString& pass = QString::null );

        KURL createURL( const QString& protocol, const QString& host,
                        const QString& user, const QString& pass );
        void createListJob( const KURL& url, HostData* hdata );
    private:
        class Private;
        Private *d;

        QIntDict<FileData>   m_jobs;
        QPtrDict<HostData>   m_pendingData;
        long m_id;
    };
}

#endif
