/***************************************************************************
                          poplistview.cpp  -  description
                             -------------------
    begin                : Thu Oct 28 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "poplistview.h"

popListView::popListView(QWidget *parent, const char *name):QListView(parent,name)
	{
	setAllColumnsShowFocus(TRUE);
	popup = new KPopupMenu(this);
	triggerUpdate();

  lastRootItem = 0;
  lastChildItem = 0;

  setFrameStyle( QFrame::Box | QFrame::Sunken );
	setLineWidth( 1 );
	setMidLineWidth( 0 );
	}

popListView::~popListView()
{
}

/*--------------------------------------------
 * insertRootItem
 *-----------------------------------------------------------------*/
QListViewItem *popListView::insertRootItem(const QString& aName, QPixmap* icon)
{
  QListViewItem *item;

  // Make sure the entry gets added AFTER the last entry.
  if( lastRootItem != 0 )
  {
    item =  new QListViewItem( this, lastRootItem );
    item->setText( 0, aName );
  }
  else
    item = new QListViewItem( this, aName );

  if(icon != 0) item->setPixmap(0, *icon );

  // Save this as the last entry.
  lastRootItem = item;

  return item;
}

/*--------------------------------------------
 * insertChildItem()
 *-----------------------------------------------------------------*/
QListViewItem *popListView::insertChildItem(const QString& aName, QPixmap* icon, QListViewItem *parent)
{
  QListViewItem *item;
	
	if(parent != 0)
	  item = new QListViewItem( parent, lastChildItem, aName );
	else
		item = new QListViewItem( lastRootItem, lastChildItem, aName );
  if(icon != 0) item->setPixmap( 0, *icon );

  // Save this as the last entry.
	lastChildItem = item;

  return item;
}

void popListView::clear()
	{
  lastRootItem = 0;
  lastChildItem = 0;
	QListView::clear();
	}
	
int popListView::insertPopupItem(const QString& name, int id, int index)
	{
	return(popup->insertItem(name, id, index));
	}

int popListView::insertPopupItem(const QString& name, QPopupMenu* pop, int id, int index)
  {
  return(popup->insertItem(name, pop, id, index));
  }
	
void popListView::contentsMousePressEvent(QMouseEvent *e)
	{
	QPoint p(e->x(), e->y());
	QListViewItem* it = itemAt(p);
	if(it)
		{
		setSelected(it, TRUE);
		}
	else
		{
		if(pstyle == ShowAnywhere) setSelected(currentItem(), FALSE);
		}
	if(e->button() == Qt::RightButton && popup->count() > 0)
		{
		if(pstyle == ShowAnywhere || (it && pstyle == OverItem))
			popup->popup(QCursor::pos());
		}
	// notify other widgets
	emit selectionChanged(it);
	}
		
KPopupMenu *popListView::popupMenu()
	{
	return(popup);
	}	

/** sets the behaviour of the popup menu */
void popListView::setPopupStyle(PopupStyle p)
{
pstyle = p;
}

/** returns the current popup style */
popListView::PopupStyle popListView::popupStyle()
{
return pstyle;
}

