#ifndef __XWire_CLASS__
#define __XWire_CLASS__

#include <list.h>
#include <device.h>
#include <qpixmap.h>
#include <xdevice.h>
#include <wire.h>

/*********************************************
* a connection between two devices
*********************************************/
class XWire: public Wire
{
public:
	XWire(QPoint);
	XWire();
	~XWire();

	// get information about the wire
	XDevice * outputDevice();
	int outputID();
	XDevice * inputDevice(int);
	XWire * ioWire(int);
	int getID();
	int getConnectionIndex(XDevice *);
	int getConnectionID(XDevice *);

	// erase/draw actice part and affected parts of connected wires
	void erase(QPainter *);
	void draw(QPainter *);

	// erase a whole wire and all connected wires
	void eraseWire(QPainter *);

	// node methods
	int contains(QPoint);
	int createNode(QPoint);
	void updateNode(QPoint);
	XWire * removeNode();
	void releaseNode();

	// set references in this and others, graphics and logical (device-connection)
	int connectInput(XDevice *, int, int);
	void disconnectInput(XDevice *);
	int connectOutput(XDevice *, int, int);
	void disconnectOutput();
	int isNamedInput(XDevice *, int);
	int isNamedOutput(XDevice *, int);

	// set/reset inverter
	void invertInput(XDevice *, bool);
	int inputIsInverted(XDevice *);
	void invertOutput(bool);
	int outputIsInverted();

	// check for wire-connection (this = potential connected wire), update device-connections
	int checkConnection(XWire *);

	int setColor(int);
	void garbageCollection();

	// copy of the node is part of another wire
	XWire * nodeIsForeign(QPoint *);

	// select/unselect nodes of wire or the complete wire
	int select(QRect);
	void select(int);

private:
	int id;

	// methods to determine output-device values
	XDevice *getOutputDev(int *);
	void setOutputDev(XDevice *, int);
	void removeOutputDev();
	// methods to operate in net of wires without scanning wires twice
	void resetScan();
	int wasScanned();

	// add wire-connection (node, logical conn, references in other wire)
	int connectWire(XWire *);
	int addWireReference(XWire *);
	// remove wire-connection (node, logical conn, references in other wire)
	void disconnectWire(XWire *);
	void removeWireReference(XWire *);

	// establish logical connections
        void setLogicInput(Device *, Device *);
	void resetLogicInput(Device *, Device *);
	void setLogicOutput();
	void resetLogicOutput();

	// number of output devices
	int countOutputDev();

	XDevice *in1_dev;
	int in1_id;
	XDevice *in2_dev;
	char in2_id;
	XDevice *out_dev;
	int out_id;
	XDevice *wire_dev;
	int wire_id;

	XWire *io_w2;
	XWire *io_w1;
	list<XWire> io_w;
	int scanned;

	Device *ininv[2];
	int ini[2];
	XDevice *outinv;
	int outi;
};

#endif

