#ifndef __COMMON_CLASSES__
#define __COMMON_CLASSES__

#include <list.h>
#include <qstring.h>

#define CONST_0		3
#define CONST_1		4
#define THIS		5


class ImportMapper
{
public:
	ImportMapper() {}

	~ImportMapper() {
		while (maplist.First()) {
			maplist.First()->Destroy();
		}
	}

	void init() {
		while (maplist.First()) {
			maplist.First()->Destroy();
		}
	}

	void fileID(QString id, int dev_id) {
		bool res;
		int file_id;

		file_id = id.toInt(&res);
		if (res == FALSE) file_id = -1;
		maplist.Append(&dummy, file_id, dev_id)->setText(id);
	}

	int mapID(QString id) {
		bool  res;
		int dev_id = id.toInt(&res);
		list<QString> *searched;

		if (res == FALSE) searched =  maplist.With(id);
		else searched = maplist.With(dev_id);

		if (searched) return searched->getID2();
		return -1;
	}

private:
	list<QString> maplist;
	QString dummy;
};

// equation information for the Equations dialog
class OutputInfo
{
public:
	OutputInfo() { device_id = 0; output_id = 0; };
	~OutputInfo() {};

	int device_id;
	int output_id;
	QString equation;
	QString output_name;	// output name
	QString original_output_name;

	QString getOutputName() {
		int pos = output_name.findRev('.');
		if (pos >= 0) {
			int length = output_name.length() - pos - 1;
			return output_name.right(length);
		}
		return output_name;
	};

	int outputChanged() {
		return output_name.compare(original_output_name);
	}

	int output_type;
	QString prefix;		// object prefix for the output name;
	QString suffix;		// output name extension: "(final)"|"(intern)"
};

// stack information for equation parser
class StackInfo
{
public:
	StackInfo() {
		no = 0;
		output_name = (char *)NULL;
		output_id = 0;
		position = 0;
		length = 0;
		type = 0;
	}

	~StackInfo() { }

	int no;
	char *output_name;
	int output_id;
	int type;
	int position;
	int length;
};

// a list of values
class value
{
public:
	value() {
		_is_internal = false;
		_position = 0;
		_value = 0;
	}

	void setValue(int val) {
		_value = val;
	}

	int getValue() {
		return _value;
	}

	void setInternal(bool val) {
		_is_internal = val;
	}

	bool isInternal() {
		return _is_internal;
	}

	int getPosition() {
		return _position;
	}

	void setPosition(int newpos) {
		_position = newpos;
	}

private:
	int _position;
	bool _is_internal;
	int _value;
};

#endif

