#ifndef __PROPDEV
#define __PROPDEV

#include <qdialog.h>
class KLineEdit;

class QWidget;
class QLabel;
class QPushButton;
class QRadioButton;
class QButtonGroup;
class QCheckBox;

class NetWidget;
class XDevice;
class InverterWidget;

class DevProp : public QDialog
{
    Q_OBJECT

public:
    DevProp(QWidget *, const char *, NetWidget *, XDeviceNet *, XDevice *);

private:
    void done(int);
    void setSize(int);

    QPushButton *bEQU;
    QPushButton *bOK;
    QPushButton *bCancel;
    KLineEdit *devname;
    KLineEdit *delay;
    KLineEdit *size;
    InverterWidget *devw;
    QButtonGroup *bg_undef;
    QRadioButton *undef[2];
    QButtonGroup *bg_invert;
    QRadioButton *invert[2];
    QButtonGroup *bg_clock;
    QRadioButton *clock[5];
    QButtonGroup *bg_master;
    QRadioButton *master[2];
    QCheckBox *cb_display_name;
    QButtonGroup *bg_led;
    QRadioButton *led_red;
    QRadioButton *led_blue;
    QRadioButton *led_green;
    QRadioButton *led_yellow;
    QLabel *label0;
    QLabel *label1;
    QLabel *label2;
    QLabel *label5;

    NetWidget *netw;
    XDeviceNet *dnet;
    XDevice *dev;
    int osize;
    int omaster;
    int oclock;
    int curr_invert;
    int curr_undef;
    int curr_clock;

signals:
    void delayChange();

private slots:
    void showDeviceEquations();
    void setSize(const QString &);
    void setUndefined(int);
    void setInverted(int);
    void setClock(int);
    void setMaster(int);
    void setLEDColor(int);
};

#endif
