/*************************************************/
/* methods for class DlgName                     */
/*                                               */
/* name property dialog                          */
/*                                               */
/* Andreas Rostin                                */
/* 15.01.99                                      */
/*************************************************/
#include <klineedit.h>

#include <qdialog.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include <klogic.h>
#include <dlgName.h>
#include "dlgName.moc"

DlgName::DlgName(QWidget *parent, const char *_caption, const char *_content)
	: QDialog(parent, _caption, TRUE, WStyle_DialogBorder)
{
    content = (char *)_content;

    label0 = new QLabel((QWidget *)this, (const char *)NULL);
    label0->setGeometry(30, 10, 43, 20);
    label0->setText(klocale->translate("name"));
    name = new KLineEdit((QWidget *)this, (const char *)NULL);
    name->setGeometry(80, 10, 80, 20);
    name->setCaption("(null)");
    name->setMaxLength(4);

    bCancel = new QPushButton(this);
    bCancel->setGeometry(108, 50, 60, 25);
    bCancel->setText(klocale->translate("Cancel"));

    bOK = new QPushButton(this);
    bOK->setGeometry(25, 50, 60, 25);
    bOK->setDefault(true);
    bOK->setText(klocale->translate("OK"));

    setCaption(_caption);
    setFixedSize(195, 95);
    name->setText(content);

    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

void DlgName::done(int r)
{
	if (r == Accepted) {
		content = strdup((char *)(const char *)name->text());
	}
	QDialog::done(r);
}

char * DlgName::getName()
{
	if (strlen(content) > 0)
		return content;
	else return (char *)NULL;
}
