/*************************************************/
/* methods for class ClientW                     */
/*                                               */
/* window containing a scrollable logic circuit  */
/*                                               */
/* Andreas Rostin                                */
/* 12.03.99                                      */
/*************************************************/
#include <qtoolbar.h>
#include <qtoolbutton.h>

#include <qframe.h>
#include <qrect.h>
#include <qpushbutton.h>
#include <qframe.h> 
#include <qpixmap.h> 
#include <qkeycode.h>
#include <qscrollbar.h>

#include <klogic.h>
#include <mainw.h>
#include <netw.h>
#include <xnet.h>
#include <clientw.h>

#include "clientw.moc"

/***************************************************/
/* methods of class ClientW                        */
/***************************************************/
// main widget content
ClientW::ClientW(MainWidget *mainw, char *file=(char *)NULL)
	: QFrame(mainw)
{	QString caption = ME;

	caption.append(" - circuit");
	setCaption((const char *)caption); 

	mainwidget = mainw;
	netframe = new QFrame(this);
	netwidget = new NetWidget(netframe, mainw);
	if (file) netwidget->openNet(file, 1);
        connect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));

	commonConstruct();

	toolbar->hide();
	client = 0;
}

// client widget content
ClientW::ClientW(MainWidget *mainw, int id)
	: QFrame()
{	QString caption = ME;

	mainwidget = mainw;
	netframe = new QFrame(this);
	netwidget = (NetWidget *)NULL;
	caption.append(" - circuit");
	setCaption((const char *)caption); 

	commonConstruct();

	toolbar->show();
	client = id;
}

void ClientW::commonConstruct()
{	QPixmap px;

	setBackgroundMode( PaletteBase );    // set widgets background

        vscroll = new QScrollBar(0, VIRT_SCREEN_SIZE_Y, 10, 100, 0, QScrollBar::Vertical, this);
        hscroll = new QScrollBar(0, VIRT_SCREEN_SIZE_X, 10, 100, 0, QScrollBar::Horizontal, this);
        connect(vscroll, SIGNAL(valueChanged(int)), this, SLOT(vScroll(int)));
        connect(hscroll, SIGNAL(valueChanged(int)), this, SLOT(hScroll(int)));

        setWidgets();

        toolbar = new QToolBar("up", mainwidget, this, FALSE, 0, Qt::WStyle_NoBorder);
        px.load((const char *)(MainWidget::TBPATH + "tbUP.xpm"));
	QToolButton *t = new QToolButton(px, NULL, NULL, this, SLOT(up()), toolbar);
	t->setFixedWidth(30);
	toolbar->setFixedWidth(43);
/*	toolbar->insertButton(px, ID_UP, SIGNAL(clicked(int)),
                this, SLOT(menuCallback(int)), TRUE, "parent circuit", -1);
        toolbar->setMaxWidth(43);
        toolbar->enableMoving(FALSE);
        toolbar->updateRects(true);
*/
}

ClientW::~ClientW()
{
}

void ClientW::hide()
{
	if (netwidget && client) {
		disconnect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));
		delete netwidget;
		netwidget = (NetWidget *)NULL;
		QWidget::hide();
		emit chidden(this);
	}
}

void ClientW::show()
{
	QWidget::show();
}

void ClientW::show(XDeviceNet *devnet)
{
	if (netwidget) fatal("client widget has a circuit already..\n");
	netwidget = new NetWidget(netframe, mainwidget, devnet);
	connect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));
	logicPos.setWidth(0);
	logicPos.setHeight(0);
	setWidgets();
	QWidget::show();
	netwidget->show();
}

NetWidget * ClientW::net()
{
	return netwidget;
}

//slot
void ClientW::keyPressEvent (QKeyEvent * e)
{
	if (client) {
		switch (e->key()) {
		case Key_S:
			mainwidget->menuCallback(NetWidget::MODE_SIM_STEP);
			break;
		case Key_M:
			mainwidget->menuCallback(NetWidget::MODE_SIM_MULT);
			break;
		case Key_G:
			mainwidget->menuCallback(ID_SIM_SHOW);
			break;
		}
	}
}

// slot
void ClientW::paintEvent(QPaintEvent *)
{
	setWidgets();
	netwidget->repaint(FALSE);
}

// set position of child-widgets and range of scrollbars
void ClientW::setWidgets()
{	vscroll->setGeometry(width() - 16, 0, 16, height() - 16 - 0);
	hscroll->setGeometry(0, height() - 16, width() - 16, 16);

	logicBase.setRect(0, 0, width() - 16, height() - 16 - 0);
	netframe->setGeometry(logicBase);
	hscroll->setRange(0, VIRT_SCREEN_SIZE_X - logicBase.width());
	vscroll->setRange(0, VIRT_SCREEN_SIZE_Y - logicBase.height());

	if ((logicPos.width() != logicBase.width()) || (logicPos.height() != logicBase.height())) {
		logicPos.setX(hscroll->value());
		logicPos.setWidth(logicBase.width());
		logicPos.setY(vscroll->value());
		logicPos.setHeight(logicBase.height());
		emit visibleChanged(logicPos);
	}
}

// slot
// horizontal scrollbar signaled that value changed
void ClientW::hScroll(int val)
{
	logicPos.setX(val);
	logicPos.setWidth(logicBase.width());
	netwidget->move(-1 * logicPos.x(), -1 * logicPos.y());
	emit visibleChanged(logicPos);
}

// slot
// vertical scrollbar signaled that value changed
void ClientW::vScroll(int val)
{
	logicPos.setY(val);
	logicPos.setHeight(logicBase.height());
	netwidget->move(-1 * logicPos.x(), -1 * logicPos.y());
	emit visibleChanged(logicPos);
}

// slot
// client id has changed
void ClientW::idChanged(int old, int id)
{
	if (client == old)
		client = id;
}

// slot
// switch to parent circuit
void ClientW::up()
{
	netwidget->toParentNet();
	repaint(FALSE);
	if (!netwidget->getActive()->parent()) toolbar->hide();
	else toolbar->show();
}

// slot
// net-widget has a new devnet
void ClientW::netChange(int hasparent)
{
	if (hasparent) toolbar->show();
	else toolbar->hide();
	hscroll->setValue(0);
	vscroll->setValue(0);
	hScroll(0);
	vScroll(0);
	repaint();
}

