/*
 * klendar.cpp
 *
 * Copyright (C) 2000 Matthias Lieber <Mali_@web.de>
 */
#include "klendar.h"

#include <khelpmenu.h>
#include <kaboutdata.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kglobal.h>
#include <kconfig.h>
#include <stdio.h>
#include <stdlib.h>
#include <qlist.h>
#include <qdatetime.h>
#include <qstring.h>
#include <qtimer.h>

extern bool Restart;
extern int XPos,YPos;
extern KAboutData about;

klendar::klendar()
    :QWidget(),fileLoaded(false),fileOk(false),w(250)
{
	Restart=false;
	int h=100;
    CDate=QDate::currentDate();
    setFixedSize(w,h+30);

	move(XPos,YPos);
    kl = new KLocale("");
	setCaption(kl->formatDate(CDate,false));

    getConfig();
    if (cfile && cfile != QString(""))
        loadFile();
    else
    {
        QLabel *label1 =new QLabel(i18n("Please configure KLendar"),this);
        label1->setGeometry(0,0,w,h);
        label1->setAlignment(QFrame::AlignCenter);
    }

    if (!fileLoaded && cfile)
    {
        QString str;
        str=QString(i18n("The file >"));
        str.append(cfile);
        str.append(i18n("< does not exist.\nPlease configure KLendar."));
        QLabel *label2 =new QLabel(str,this);
        label2->setGeometry(0,0,w,h);
        label2->setAlignment(QFrame::AlignCenter);
    }

    if (fileLoaded && cfile && fileOk)
    {
        search();
        h=(News.count())*20+30;
        labels();
        setFixedSize(w,h+30);
        QString today=QString(i18n(" Today: "));
		QFrame *line1=new QFrame(this);
		line1->setFrameStyle(QFrame::Sunken | QFrame::HLine);
		line1->setGeometry(0,20,w,10);
        today.append(kl->formatDate(CDate,false));
        Today=new QLabel(today,this);
        Today->setGeometry(0,0,w,20);
    }
	if (fileLoaded && cfile && !fileOk)
    {
	    QString str;
        str=QString(i18n("The file \n>"));
        str.append(cfile);
        str.append(i18n("<\n is no valid calendar file.\nPlease configure KLendar."));
        QLabel *label3 =new QLabel(str,this);
        label3->setGeometry(0,0,w,h);
        label3->setAlignment(QFrame::AlignCenter);
    }


	QFrame *line2=new QFrame(this);
	line2->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	line2->setGeometry(0,h,w,10);

    Quit = new QPushButton(i18n("&Quit"),this);
	connect( Quit,SIGNAL(clicked()),kapp,SLOT(quit()) );
	Help = new QPushButton(i18n("&Help"),this);
	connect( Help,SIGNAL(clicked()),this,SLOT(Popup()) );
	Config = new QPushButton(i18n("&Settings"),this);
	Config->setGeometry(50,h+10,80,20);
	connect( Config,SIGNAL(clicked()),this,SLOT(ShowConfigWidget()) );
	Quit->setGeometry(w-50,h+10,50,20);
	Help->setGeometry(0,h+10,50,20);


	Update=new QTimer(this);
	connect( Update,SIGNAL(timeout()),this,SLOT(UpdateMessages()) );
	Update->start(10000,false);

	cwidget =new CWidget();
	cwidget->hide();
	// restart klendar when settings were changed
	connect( cwidget,SIGNAL(changed()),this,SLOT(restart()) );

}

void klendar::ShowConfigWidget(void)
{
    cwidget->show();
}

void klendar::UpdateMessages(void)
{
    if (CDate.day()!=(QDate::currentDate()).day())
	    restart();

}

void klendar::restart(void)
{
    XPos=x();
	YPos=y();
	Restart=true;
	kapp->quit();
}

void klendar::labels(void)
{
    int Mmaxw=0,Dmaxw=0,y,space=10,days;
    QString message,date,years;

    LabelList.clear();
    LabelList2.clear();
    DateLabel.clear();

    News.first();
    for(uint j=0;j<News.count();j++)
	{
	    int i=*(News.at(j));
    	date=kl->formatDate(QDate( CDate.year()+(*(NextYear.at(j))),(Dates.at(i))->month(),
    		(Dates.at(i))->day() ),false);
	   	date.prepend(" ");
	   	message=*(Messages.at(i));
	   	LabelList.append(new QLabel(message,this));
	   	(LabelList.last())->move(0,j*20+30);
        (LabelList.last())->setAlignment(AlignLeft|AlignVCenter);
        DateLabel.append(new QLabel(date,this));
        (DateLabel.last())->setAlignment(AlignLeft|AlignVCenter);
	   	(DateLabel.last())->move(0,j*20+30);

		if( y=( ( CDate.year()+(*(NextYear.at(j))) ) - ((Dates.at(i))->year()) ) )
	    {
	   		years.setNum(y);
	   		years.append(")");
	   		years.prepend("(");
	   	}
	   	else
	   		years=QString();
	   	LabelList2.append(new QLabel(years,this));

	   	(LabelList2.last())->setGeometry(0,j*20+30,40,20);
	   	(LabelList2.last())->setAlignment(AlignCenter);

        /*
		(LabelList2.last())->setPalette(QPalette(QColor(0,0,128)));
        (LabelList.last())->setPalette(QPalette(QColor(0,128,0)));
		(DateLabel.last())->setPalette(QPalette(QColor(128,0,0)));
		*/

		days=CDate.daysTo( QDate( CDate.year()+(*(NextYear.at(j))),(Dates.at(i))->month(),
    		(Dates.at(i))->day() ) );
        if (!days)      // event is today
		{
		    QFont f=(DateLabel.last())->font();
			f.setBold(true);
		    (DateLabel.last())->setFont(f);
			(LabelList.last())->setFont(f);
			(LabelList2.last())->setFont(f);
		}

		if( ((LabelList.last())->sizeHint()).width() > Mmaxw )
	    	Mmaxw=((LabelList.last())->sizeHint()).width();
        if( ((DateLabel.last())->sizeHint()).width() > Dmaxw )
	    	Dmaxw=((DateLabel.last())->sizeHint()).width();
	}

    if(Mmaxw+Dmaxw<150)
        Mmaxw=150-Dmaxw;
    for(uint j=0;j<News.count();j++)
	{
		(DateLabel.at(j))->resize(Dmaxw,20);
		(LabelList.at(j))->move(Dmaxw+space,(LabelList.at(j))->y());
		(LabelList.at(j))->resize(Mmaxw,20);
		(LabelList2.at(j))->move(Mmaxw+Dmaxw+space,(LabelList2.at(j))->y());

	}

    w=Dmaxw+space+Mmaxw+40;
}

void klendar::Popup(void)
{

    KHelpMenu *HelpMenu = new KHelpMenu( this, &about );
    (HelpMenu->menu())->exec(QCursor::pos());
}

void klendar::getConfig(void)
{
    // Config
    kapp->config()->setGroup("Config");
    cfile=( kapp->config()->readEntry("File",QString()) ).data();
    md=kapp->config()->readNumEntry("Days",10);

}

void klendar::loadFile(void)
{
    int k,m,d,y;
    FILE *file;
    char s[81];
    char c='\t';
	QDate test;

    Dates.clear();
    Messages.clear();

    if( ( file=fopen(cfile,"r") ) == NULL )
    {
        return;
    }

   	for(int i=0;c!=EOF;i++)
   	{
   		fscanf(file,"%d/%d/%d",&m,&d,&y);
        c=fgetc(file);

        while(c!='\"' && c!=EOF)
            c=fgetc(file);

        for(k=0;k<81;k++)
            s[k]=0;
        for(k=0;k<81 && (s[k]=fgetc(file))!='\"';k++);

        s[k]='\0';

   		if (c!=EOF)
		{
			if (test.setYMD(y,m,d))
			{
                printf("/%d/%d/%d/%s/\n",m,d,y,s);
                Dates.append(new QDate(y,m,d));
			    Messages.append(new QString(s));
            }
		}
	}
	fclose(file);

	if (Dates.count())
	    fileOk=true;

    fileLoaded=true;

}

void klendar::search(void)
{
	News.clear();
    NextYear.clear();
    int ny;
	int days;
	for(int i=0;i<=md;i++)
	{
		Dates.first();
		while(Dates.current())
		{
			days=CDate.daysTo(QDate( CDate.year(),(Dates.current())->month(),
			    (Dates.current())->day() ));
            if (days<0)
            {
                days=CDate.daysTo(QDate( CDate.year()+1,(Dates.current())->month(),
			        (Dates.current())->day() ));
                ny=1;
            }
            else
                ny=0;

            if( days==i )
            {
				News.append( new int(Dates.at()) );
                NextYear.append( new int(ny) );
            }
			Dates.next();

		}
	}

}

