/***************************************************************************
                          popups.cpp  -  description
                             -------------------
    begin                : Sun Apr 23 2000
    copyright            : (C) 2000 by Mickal Marchand
    email                : MikMak@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "popups.h"
#include <qlist.h>
#include <kmsgbox.h>
#include "people.h"
#include <stdio.h>

extern QString MYIP;
extern QStrList my_alias;
extern QString hostname;
extern QString workgroup;
extern QStrList liste_groupes;
extern QStrList existing_alias;
extern QString BROAD_ADDR;
extern QList<people> list_people;
extern QString ORIG_ALIAS;
extern QString DEST_ALIAS;
extern QString MSG_ALIAS;
extern QString IP_ALIAS;

Popups::Popups(){
}

Popups::~Popups(){
}

void Popups::new_popup (bool alias, QString Real_Dest, QString Origine, QString Destinataires, QString Message){
if (alias) {
	Send_to_alias2(Real_Dest, Origine, Destinataires, Message);
	return;
	}

if (Real_Dest==hostname){
Send_to_me(Origine,Destinataires,Message);
}

QString dest_ip;
QString resol;
QString my_nbt_name;
QString dest_nbt_name;
bool Broadcast = false;
unsigned int m;
for (m=0; m<list_people.count();m++){
if ((list_people.at(m))->get_name()==Real_Dest) resol=(const char *)((list_people.at(m))->get_ip());
}

if (resol.isNull()) {
for (m=0; m<list_people.count();m++){
if ((list_people.at(m))->get_workgroup()==Real_Dest) resol="groupe";
}
}

if (resol.isNull()) {
resol=(Resolve (Real_Dest,BROAD_ADDR)).at(0);
}

if (resol=="groupe" || Real_Dest=="TOUT LE MONDE" ||Real_Dest=="TOUS LES GENS" || Real_Dest=="*" || Real_Dest=="ALL-POPUP" || Real_Dest=="ALL") Broadcast = true;

dest_ip = resol;

/*noms netbios*/
int len_total = 173+strlen(Origine)+strlen(Destinataires)+strlen(Message);
char pop[len_total];
char *p = pop;
memset(pop,0,sizeof(pop));

my_nbt_name = make_nmb_name(hostname);

if (!Broadcast)
	{
	dest_nbt_name = make_nmb_name(Real_Dest);
	p[0] = 0x10;
	}
else
	{
	if (resol == "groupe") dest_nbt_name = make_nmb_name(Real_Dest);
	dest_ip = (const char *) BROAD_ADDR;
	p[0] = 0x11;
	}
p[1] = 02;
p[3] = 0x56;
uint tmp;
tmp = inet_addr(MYIP);
p+=4;
p[0]= tmp;
p[1]= (tmp >> 8);
p[2]= (tmp >> 16);
p[3]= (tmp >> 24);
p[5]=0x8a; //port 138
p+=6;
/*1er checksum*/
int checksum = len_total - 14;
p[1] = checksum;
if (checksum>255) p[0] = (checksum >> 8);

p+=4;
memcpy (&p[0],my_nbt_name,33);
if (resol == "groupe"|| !Broadcast) memcpy (&p[34],dest_nbt_name,33);
p+=68;
p[0] = 0xff;
p[1] = 0x53;
p[2] = 0x4d;
p[3] = 0x42;
p[4] = 0x25;
p[24] = 0xff;
p[25] = 0xff;
p[28] = 0xff;
p[29] = 0xff;
p[32] = 0x11;

/*2eme checksum*/
int checksum2 = strlen(Origine) + strlen(Destinataires) + strlen(Message) +3;
p[35] = checksum2;
if (checksum2>255) p[36] = (checksum2 >> 8);

p[43]=0x02;
p[53]=0x58;

/*3eme checksum*/
p[55] = checksum2;
if (checksum2>255) p[56] = (checksum2 >> 8);

p[57] = 0x58;
p[59] = 0x03;
p[61] = 0x01;
p[65] = 0x02;

/*4eme checksum*/
checksum2 += 19;
p[67] = checksum2;
if (checksum2>255) p[68] = (checksum >> 8);

memcpy (&p[69],"\\MAILSLOT\\MESSNGR",17);
memcpy (&p[88],Origine,strlen(Origine));
memcpy (&p[89+strlen(Origine)],Destinataires,strlen(Destinataires));
memcpy (&p[90+strlen(Origine)+strlen(Destinataires)],Message,strlen(Message));

if (!dest_ip.isEmpty()){
enhancedperms();
int socket_pop;
socket_pop = socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);
int on=1;

struct sockaddr_in sin_pop;
sin_pop.sin_family = AF_INET;
sin_pop.sin_port = htons(138);
sin_pop.sin_addr.s_addr = inet_addr(MYIP);

struct sockaddr_in sin_to;
sin_to.sin_family = AF_INET;
sin_to.sin_port = htons(138);
sin_to.sin_addr.s_addr = inet_addr(dest_ip);

setsockopt (socket_pop, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
if (Broadcast) setsockopt (socket_pop, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on));
if ((bind (socket_pop, (struct sockaddr *) &sin_pop, sizeof(sin_pop)))<0)
		KMsgBox::message(0,"Socket problem : socket_pop","KTuxPop cannot bind the socket");

if (Broadcast && resol != "groupe")
	{
	unsigned int i;
	QStrList groups;
	for (i=0; i< list_people.count(); i++)
		{
    if (groups.contains((list_people.at(i))->get_workgroup())==0) groups.append((list_people.at(i))->get_workgroup());
		}
	for (i=0 ; i < groups.count() ; i++)
		{
		dest_nbt_name = make_nmb_name(groups.at(i));
		memcpy (&pop[48],dest_nbt_name,33);
		if (sendto(socket_pop, pop, sizeof(pop), 0, (struct sockaddr *) &sin_to, sizeof(sin_to))<0)
				KMsgBox::message(0,"Socket problem : socket_pop","KTuxPop cannot send");
		}
	}
else if (sendto(socket_pop, pop, sizeof(pop), 0, (struct sockaddr *) &sin_to, sizeof(sin_to))<0)
				KMsgBox::message(0,"Socket problem : socket_pop","KTuxPop cannot send");

close (socket_pop);
normalperms();
}
}

void Popups::Send_Salup_Alias(QString dest, QString ip){
unsigned int i;
QString temp;

if ((socket_salup_sortie = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP))<0){
	KMsgBox::message(0,"Socket problem : socket_salup_sortie","KTuxPop cannot open the socket",0,0);
	exit(1);	
}

struct sockaddr_in sin_salup_sortie;
int on = 1;
sin_salup_sortie.sin_family=AF_INET;
sin_salup_sortie.sin_port = htons(9279);
sin_salup_sortie.sin_addr.s_addr = inet_addr(ip);
if (ip==BROAD_ADDR) {
	setsockopt (socket_salup_sortie, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on));
	if ((bind (socket_salup_sortie, (struct sockaddr *) &sin_salup_sortie, sizeof(sin_salup_sortie)))<0) KMsgBox::message(0,"","pbl de bind");
	my_alias.append(workgroup);
	}
my_alias.append("Tous les gens");
for (i=0 ; i < my_alias.count(); i++)
	{
	int len = 31 + strlen(dest) + strlen(hostname) + strlen(my_alias.at(i));
	unsigned char message[len];
	memset (message, 0,len);
	if (my_alias.at(i)==workgroup && ip==BROAD_ADDR) message[0] = 0xc9;
	else message[0] = 0xcb;
	message[6] = 0x10;
	message[8] = 15 + strlen(hostname) + strlen(dest) + strlen(my_alias.at(i));
	message[12] = 0x03;
	message[16] = strlen(hostname)+1;
	memcpy (&message[20], hostname, strlen(hostname));
	message[21 + strlen(hostname)] = strlen(dest)+1;
	memcpy(&message[25 + strlen(hostname)],dest,strlen(dest));
	message[26 + strlen(hostname) + strlen(dest)] = strlen(my_alias.at(i))+1;
	memcpy(&message[30 + strlen(hostname) + strlen(dest)],my_alias.at(i),strlen(my_alias.at(i)));
	if (sendto(socket_salup_sortie, message, sizeof(message), 0, (struct sockaddr *) &sin_salup_sortie, sizeof(sin_salup_sortie))<0)	KMsgBox::message(0,"","pbl");
	}
close (socket_salup_sortie);
my_alias.removeLast();
if (ip==BROAD_ADDR) my_alias.removeLast();
#ifdef DBG
for (i=0;i<my_alias.count();i++)
{
printf ("Mes alias :%s\n",my_alias.at(i));
}
#endif
}

void Popups::Requete_Alias_Salup(){
if ((socket_salup_sortie = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP))<0){
	KMsgBox::message(0,"Socket problem : socket_salup_sortie","KTuxPop cannot open the socket",0,0);
	exit(1);	
}
struct sockaddr_in sin_salup_sortie;
int on = 1;
sin_salup_sortie.sin_family=AF_INET;
sin_salup_sortie.sin_port = htons(9279);
sin_salup_sortie.sin_addr.s_addr = inet_addr(BROAD_ADDR);
setsockopt (socket_salup_sortie, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on));
if ((bind (socket_salup_sortie, (struct sockaddr *) &sin_salup_sortie, sizeof(sin_salup_sortie)))<0) KMsgBox::message(0,"","pbl de bind");
	int len = 27 + strlen(hostname);
	unsigned char message[len];
	memset (message, 0,len);
	message[0] = 0x64;
	message[6] = 0x10;
	message[8] = 11 + strlen(hostname);
	message[12] = 0x02;
	message[16] = strlen(hostname)+1;
	memcpy (&message[20], hostname, strlen(hostname));
	message[21 + strlen(hostname)] = 0x02;
	message[25 + strlen(hostname)] = '*';
	if (sendto(socket_salup_sortie, message, sizeof(message), 0, (struct sockaddr *) &sin_salup_sortie, sizeof(sin_salup_sortie))<0)	KMsgBox::message(0,"","pbl");
close (socket_salup_sortie);
}

void Popups::Send_byebye_Salup(){
unsigned int i;
if ((socket_salup_sortie = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP))<0){
	KMsgBox::message(0,"Socket problem : socket_salup_sortie","KTuxPop cannot open the socket",0,0);
	exit(1);	
}
struct sockaddr_in sin_salup_sortie;
int on = 1;
sin_salup_sortie.sin_family=AF_INET;
sin_salup_sortie.sin_port = htons(9279);
sin_salup_sortie.sin_addr.s_addr = inet_addr(BROAD_ADDR);
setsockopt (socket_salup_sortie, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on));
if ((bind (socket_salup_sortie, (struct sockaddr *) &sin_salup_sortie, sizeof(sin_salup_sortie)))<0) KMsgBox::message(0,"","pbl de bind");
my_alias.append(workgroup);
my_alias.append("Tous les gens");
for (i=0 ; i < my_alias.count(); i++)
	{
	int len = 32 + strlen(hostname) + strlen(my_alias.at(i));
	unsigned char message[len];
	memset (message, 0,len);
	if (my_alias.at(i)==workgroup) message[0] = 0xca;
	else message[0] = 0xcd;
	message[6] = 0x10;
	message[8] = 16 + strlen(hostname) + strlen(my_alias.at(i));
	message[12] = 0x03;
	message[16] = strlen(hostname)+1;
	memcpy (&message[20], hostname, strlen(hostname));
	message[21 + strlen(hostname)] = 0x02;
	message[25 + strlen(hostname)] = '*';
	message[27 + strlen(hostname)] = strlen(my_alias.at(i))+1;
	memcpy(&message[31 + strlen(hostname)],my_alias.at(i),strlen(my_alias.at(i)));
	if (sendto(socket_salup_sortie, message, sizeof(message), 0, (struct sockaddr *) &sin_salup_sortie, sizeof(sin_salup_sortie))<0)	KMsgBox::message(0,"Send","Problme d'envoi");
	}
my_alias.removeLast();
my_alias.removeLast();
close (socket_salup_sortie);
}

void Popups::InitSalup(){
Send_Salup_Alias("*",BROAD_ADDR);
Requete_Alias_Salup();
}

void Popups::Send_to_alias2(QString Real_Dest, QString Origine, QString Destinataires, QString Message){
//trouve les vrais destinataires
if (my_alias.contains(Real_Dest)){
	Send_to_me(Origine,Destinataires,Message);
}

QStrList destinations;
QString ip_dest;
QString person;
unsigned int i;
int idx = existing_alias.find (Real_Dest)+1;
QString tp(existing_alias.at(idx));
while (tp != tp.upper()){
	destinations.append (tp.upper());
	idx++;
	tp = existing_alias.at(idx);
	}
for (i=0 ; i < destinations.count() ; i++){
person = destinations.at(i);

QString dest_ip;
QString resol;
QString my_nbt_name;
QString dest_nbt_name;
bool Broadcast = false;
unsigned int m;
for (m=0; m<list_people.count();m++){
	if ((list_people.at(m))->get_name()==person) resol=(const char *)((list_people.at(m))->get_ip());
}

if (resol.isNull()) {
	for (m=0; m<list_people.count();m++){
	if ((list_people.at(m))->get_workgroup()==person) resol="groupe";
	}
}

if (resol.isNull()) resol=(Resolve (person,BROAD_ADDR)).at(0);

dest_ip = resol;

/*noms netbios*/
int len_total = 173+strlen(Origine)+strlen(Destinataires)+strlen(Message);
char pop[len_total];
char *p = pop;
memset(pop,0,sizeof(pop));

my_nbt_name = make_nmb_name(hostname);

if (!Broadcast){
	dest_nbt_name = make_nmb_name(person);
	p[0] = 0x10;
	}
else{
	if (resol == "groupe") dest_nbt_name = make_nmb_name(person);
	dest_ip = (const char *) BROAD_ADDR;
	p[0] = 0x11;
	}
p[1] = 02;
p[3] = 0x56;
uint tmp;
tmp = inet_addr(MYIP);
p+=4;
p[0]= tmp;
p[1]= (tmp >> 8);
p[2]= (tmp >> 16);
p[3]= (tmp >> 24);
p[5]=0x8a; //port 138
p+=6;
/*1er checksum*/
int checksum = len_total - 14;
p[1] = checksum;
if (checksum>255) p[0] = (checksum >> 8);

p+=4;
memcpy (&p[0],my_nbt_name,33);
if (resol == "groupe"|| !Broadcast) memcpy (&p[34],dest_nbt_name,33);
p+=68;
p[0] = 0xff;
p[1] = 0x53;
p[2] = 0x4d;
p[3] = 0x42;
p[4] = 0x25;
p[24] = 0xff;
p[25] = 0xff;
p[28] = 0xff;
p[29] = 0xff;
p[32] = 0x11;

/*2eme checksum*/
int checksum2 = strlen(Origine) + strlen(Destinataires) + strlen(Message) +3;
p[35] = checksum2;
if (checksum2>255) p[36] = (checksum2 >> 8);

p[43]=0x02;
p[53]=0x58;

/*3eme checksum*/
p[55] = checksum2;
if (checksum2>255) p[56] = (checksum2 >> 8);

p[57] = 0x58;
p[59] = 0x03;
p[61] = 0x01;
p[65] = 0x02;

/*4eme checksum*/
checksum2 += 19;
p[67] = checksum2;
if (checksum2>255) p[68] = (checksum >> 8);

memcpy (&p[69],"\\MAILSLOT\\MESSNGR",17);
memcpy (&p[88],Origine,strlen(Origine));
memcpy (&p[89+strlen(Origine)],Destinataires,strlen(Destinataires));
memcpy (&p[90+strlen(Origine)+strlen(Destinataires)],Message,strlen(Message));

if (!dest_ip.isEmpty()){
enhancedperms();
int socket_pop;
socket_pop = socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);
int on=1;

struct sockaddr_in sin_pop;
sin_pop.sin_family = AF_INET;
sin_pop.sin_port = htons(138);
sin_pop.sin_addr.s_addr = inet_addr(MYIP);

struct sockaddr_in sin_to;
sin_to.sin_family = AF_INET;
sin_to.sin_port = htons(138);
sin_to.sin_addr.s_addr = inet_addr(dest_ip);

setsockopt (socket_pop, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
if (Broadcast) setsockopt (socket_pop, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on));
if ((bind (socket_pop, (struct sockaddr *) &sin_pop, sizeof(sin_pop)))<0)
		KMsgBox::message(0,"Socket problem : socket_pop","KTuxPop cannot bind the socket");

if (Broadcast && resol != "groupe")
	{
	unsigned int i;
	QStrList groups;
	for (i=0; i< list_people.count(); i++)
		{
    if (groups.contains((list_people.at(i))->get_workgroup())==0) groups.append((list_people.at(i))->get_workgroup());
		}
	for (i=0 ; i < groups.count() ; i++)
		{
		dest_nbt_name = make_nmb_name(groups.at(i));
		memcpy (&pop[48],dest_nbt_name,33);
		if (sendto(socket_pop, pop, sizeof(pop), 0, (struct sockaddr *) &sin_to, sizeof(sin_to))<0)
				KMsgBox::message(0,"Socket problem : socket_pop","KTuxPop cannot send");
		}
	}
else if (sendto(socket_pop, pop, sizeof(pop), 0, (struct sockaddr *) &sin_to, sizeof(sin_to))<0)
				KMsgBox::message(0,"Socket problem : socket_pop","KTuxPop cannot send");

close (socket_pop);
normalperms();
}
}
}

void Popups::Send_to_me(QString Origine,QString destinataires,QString Message){
char timebuf[10];
struct tm *timeptr;
time_t nw;
nw = time((time_t *)NULL);
timeptr= localtime(&nw);
strftime (timebuf, sizeof(timebuf), "%X\n",timeptr);
QString temp(timebuf);
ORIG_ALIAS=Origine;
DEST_ALIAS=destinataires;
MSG_ALIAS=timebuf+Message;
IP_ALIAS=MYIP;
}
