/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : lun avr 17 13:02:59 CEST 2000
    copyright            : (C) 2000 by Mickal Marchand
    email                : MikMak@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktuxpop.h"

bool beeper = true;
int restaurer = 0;
bool loguer = true;
bool showlogo = true;
bool filtrer_all = false;
bool filtrer_groupe = false;
bool filtrer_persos = false;
bool filtre_actif = false;
bool replyer = false;
extern QString BROAD_ADDR;
extern QList<people> list_people;
QTime timer_browse;
extern bool starting;
extern QStrList existing_alias;
extern QStrList my_alias;
extern QString hostname;
QString appdir;
int ruid,euid;

int main(int argc, char *argv[])
{
/* security functions*/
ruid=getuid();
euid=geteuid();
normalperms();	

  KApplication app(argc, argv, "ktuxpop");
	appdir = kapp->kde_datadir() + "/ktuxpop";
	if (argc>3)samba_message(argc,argv);

  if (app.isRestored())
  {
    RESTORE(KTuxPop);
  }
  else 
  {
    KTuxPop *ktuxpop = new KTuxPop();
		ktuxpop->setFixedSize(400,400);
    ktuxpop->show();
		ktuxpop->setCaption("KTuxPop 1.2");
  }
  return app.exec();
}  

void samba_message(int argc,char *argv[]){
int ij;
int file_handle;
FILE *in;
char mes[1000];
struct tm *timeptr;
char timebuf[10];
time_t nw;
nw = time((time_t *)NULL);
timeptr= localtime(&nw);
strftime (timebuf, sizeof(timebuf), "%X",timeptr);
memset (mes, 0, 1000);
in = fopen (argv[3], "r");
ij = fread (mes, 1, sizeof(mes), in);
fclose (in);

QString smbmsg;
smbmsg.sprintf("%s\n%s\n", timebuf, mes);

QString host (argv[2]);
host += '\0';
QString desthost (argv[1]);
desthost += '\0';
enhancedperms();
if (access (appdir + "/ktuxpop.msg", F_OK))
  file_handle = open (appdir + "/ktuxpop.msg", O_WRONLY | O_CREAT, DATA_PERM);
else
  file_handle = open (appdir + "/ktuxpop.msg", O_WRONLY | O_APPEND, DATA_PERM);

(void) lock_reg (file_handle, F_SETLKW, F_WRLCK, 0, SEEK_SET, 0);
write (file_handle, host, strlen(host)+1);
write (file_handle, desthost, strlen(desthost)+1);
write (file_handle, smbmsg, 998-strlen(host)-strlen(desthost));
(void) lock_reg (file_handle, F_SETLK, F_UNLCK, 0, SEEK_SET, 0);

close (file_handle);
normalperms();
exit (0);
}

int lock_reg (int fd, int cmd, int type, off_t offset, int whence, off_t len)
{
  struct flock lock;
  lock.l_type = type;
  lock.l_start = offset;
  lock.l_whence = whence;
  lock.l_len = len;
  return (fcntl (fd, cmd, &lock));
}

QStrList Resolve(QString name,QString dest_ip){
enhancedperms();
char buffer[500];
QString nom;
nom = make_nmb_name(name);
char message[50];
memset(message,0,50);
if (dest_ip==BROAD_ADDR) {
message[2] = 0x01;
message[3] = 0x10;
}
message[5] = 0x01;
memcpy (&message[12],nom,strlen(nom));
if (dest_ip==BROAD_ADDR)
{message[47] = 0x20;}
else
{message[47] = 0x21;}

message[49] = 0x01;
if (name=="*") {
message[43]=0x41;
message[44]=0x41;
}
int on=1;
int socket_resolve = socket (AF_INET,SOCK_DGRAM,IPPROTO_UDP);
if (socket_resolve < 0)
	{
	KMsgBox::message(0,"Socket problem : socket_resolve","KTuxPop cannot open the socket");
	exit(1);
	}
if (fcntl (socket_resolve, F_SETFL, O_NDELAY)<0) {
	KMsgBox::message(0,"Socket problem : socket_resolve","KTuxPop cannot establish the socket in non-blocking mode",0,0);
	exit(1);
}
struct sockaddr_in sockaddr_resolve;
sockaddr_resolve.sin_family = AF_INET;
sockaddr_resolve.sin_port = htons(137);
sockaddr_resolve.sin_addr.s_addr = inet_addr((const char *)dest_ip);
setsockopt (socket_resolve, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
if (dest_ip==BROAD_ADDR) {setsockopt (socket_resolve, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on));}
if (sendto(socket_resolve, message, sizeof(message), 0, (struct sockaddr *) &sockaddr_resolve, sizeof(sockaddr_resolve))<0)	KMsgBox::message(0,"Resolve","Send Problem");
QTime t;
t.start();
struct sockaddr_in fr;
unsigned int frlen = sizeof(fr);
QString ip_received;
QStrList ip_list;
ip_list.clear();
int i;
while (t.elapsed() <= 500)
	{
	i = recvfrom(socket_resolve, buffer, sizeof(buffer),0,(struct sockaddr *) &fr, &frlen);
	if (i>0){
	if (dest_ip==BROAD_ADDR) {
		ip_received.sprintf("%s", inet_ntoa(fr.sin_addr));
		if (ip_list.contains((const char *)ip_received)==0)	{	ip_list.append (ip_received);}
		}
		else {
		//find names corresponding to this ip
		int v;
		char nom[16];
		memset(nom,0,sizeof(nom));
		char groupe[16];
		memset(groupe,0,sizeof(groupe));
		for (v=70;v<i;v++)
		{
		if (buffer[v] == 0x00 && buffer[v+1]==0x04 && buffer[v+2]==0x00)
			{
			memcpy (&nom[0],&buffer[v-15],15);
			nom[15]=0x00;
			}
		if (buffer[v] == 0x00 && (unsigned)buffer[v+1]==0xffffff84 && buffer[v+2]==0x00 ) // i know it is not really clear, but it does its job :o)
			{
			memcpy (&groupe[0],&buffer[v-15],15);
			groupe[15]=0x00;
			}
		}
		ip_list.append((const char *)nom);
		ip_list.append((const char *)groupe);
		}
		}
	}
close (socket_resolve);
normalperms();
return ip_list;
}

QString make_nmb_name(const char *In)
{
  int   i;
  int   c;
	char Out[34];
  char buf[15];
  char *p = Out;

  (void)memset( buf, 0x20, 15 );
  if (strcmp(In,"*") == 0)
	{
	  (void)memset( buf, 0, 15 );
    buf[0] = '*';
	}
  else
	{
		memcpy (buf, In, strlen(In));
		buf[15]='\0';
	}

  p[0] = 32;
  p++;

  for( i = 0; i < 16; i++ )
    {
    c = toupper( buf[i] );
    p[i*2]     = ( (c >> 4) & 0x000F ) + 'A';
    p[(i*2)+1] = (c & 0x000F) + 'A';
    }
  p += 32;
  p[0] = '\0';

QString fin(Out);
return fin;
}

void *scan_people(void * arg){
pthread_setcancelstate(PTHREAD_CANCEL_ENABLE,NULL);
QStrList temp_ip_list;
QStrList List_name;
unsigned int i,l;
bool found=false;
QString stripname;
QString stripgroup;
QString stripip;
timer_browse.restart();
	temp_ip_list = Resolve("*",BROAD_ADDR);
	list_people.clear();
#ifdef DBG
	printf("Cleaning people list...\n");
#endif
	for (i=0;i<temp_ip_list.count();i++) {
	found=false;
	List_name=Resolve ("*",temp_ip_list.at(i));
	if ( (List_name.at(0))!=NULL && (List_name.at(1))!=NULL) {
	stripip = temp_ip_list.at(i);
	stripip = stripip.stripWhiteSpace();
	stripname = List_name.at(0);
	stripname = stripname.stripWhiteSpace();
	stripgroup = List_name.at(1);
	stripgroup = stripgroup.stripWhiteSpace();
	for (l=0;l<list_people.count();l++){
	if ((list_people.at(l))->get_name() == stripname) found=true;
	}
	if (!found){
	list_people.append(new people(stripip,stripname,stripgroup));
#ifdef DBG
	printf ("New people entry...%s %s %s\n",(const char*)stripip,(const char*)stripname,(const char*)stripgroup);
#endif
	}
	}
	pthread_testcancel();
	}
#ifdef DBG
	printf("Listing people...\n");
	for (i=0;i<list_people.count();i++) {
	printf ("%s %s %s\n",(const char *)(list_people.at(i))->get_ip(),(const char *)(list_people.at(i))->get_name(),(const char *)(list_people.at(i))->get_workgroup());
	}
#endif
existing_alias.clear();
for (i=0 ; i < my_alias.count() ; i++){
existing_alias.append(my_alias.at(i));
existing_alias.append(hostname.lower());
}
Popups *popups_temp = new Popups();
popups_temp->Requete_Alias_Salup();
delete popups_temp;
pthread_exit(0);
}

void normalperms(void){
 if (seteuid(ruid)==-1) {
#ifdef DBG
		printf("Failed to get ruid : %i\n",ruid);
#endif
		exit(2);
	}
	else{
#ifdef DBG
   	printf("get ruid successful: %i\n",ruid);
#endif
	}
		
}

void enhancedperms(void){
	if (seteuid(euid)==-1){
#ifdef DBG
		printf("Failed to get euid : %i\n",euid);
#endif
		exit(2);
	}
	else{
#ifdef DBG
		printf("get euid successful: %i\n",euid);
#endif
	}
}
