#include <qpushbutton.h>
#include <kmessagebox.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <klocale.h>
#include <qlabel.h>
#include <stdio.h>
#include <kapp.h>
#include "rogue/dun.h"
#include "kmsgbar.h"
#include "kinvwnd.h"
#include "roguec.h"
#include "kcmdr.h"
#include "kdun.h"

object *objfirst(int mask, int inusemask)
{
  return objnext(&rogue.pack, mask, inusemask);
}

object *objnext(object *obj, int mask, int inusemask)
{
  obj=obj->next_object;
  while (obj!=NULL)
  {
    if ((obj->what_is&mask) && !(obj->in_use_flags&inusemask)) return obj;
    obj=obj->next_object;
  }
  return NULL;
}

char *objstr(object *obj, char *str)
{
  char buf[MSGLEN];
  sprintf(str, "%c) ", obj->ichar);
  get_desc(obj, buf);
  APPEND(str, buf, MSGLEN);
  return str;
}

class KItemLVI: public QListViewItem
{
public:
  KItemLVI(object *_obj, QListView *view);
  virtual ~KItemLVI(void) {}
  virtual QString text(int i) const;
  virtual const QPixmap *pixmap(int i) const;
  virtual void refresh();
  object *obj;
protected:
  QString c;
};

KItemLVI::KItemLVI(object *_obj, QListView *view)
:QListViewItem(view)
{
  obj=_obj;
  c=QString::null;
  refresh();
}

void KItemLVI::refresh()
{
  char str[MSGLEN];
  c=QString::fromUtf8(objstr(obj, str));
}

QString KItemLVI::text(int i) const
{
  if (i==0) return c;
    else return QString::null;
}

const QPixmap *KItemLVI::pixmap(int i) const
{
  if (i==0) return dun->itempix[KInvWnd::getObjIconId(obj)];
    else return NULL;
}

KInvWnd::KInvWnd(QWidget *parent, char *name, int amask, bool select,
  object *apack)
:QDialog(parent, name, TRUE)
{
  if (apack) pack=apack; else pack=&rogue.pack;
  mask=amask;

  object *obj=objnext(pack, amask);
  if (obj==NULL)
  {
    if (amask==ALL_OBJECTS)
      KMessageBox::information(parent,i18n("Your pack is empty"),  i18n("Rogue"));
      else KMessageBox::information(parent, i18n("Nothing apropriate"), i18n("Rogue"));
    close=NULL;
    return;
  }

  setCaption(i18n("Inventory"));
  resize(320, 420);
  if (select)
  {
    use=new QPushButton(i18n("&Select"), this);
    connect(use, SIGNAL(clicked()), SLOT(selectbt()));
    use->setDefault(true);
  } else
  {
    use=new QPushButton(i18n("&Use"), this);
    connect(use, SIGNAL(clicked()), SLOT(usebt()));
    if (cmdr->readOnly()) use->setEnabled(false);
  }
  use->setGeometry(30, 380, 115, 30);
  close=new QPushButton(i18n("&Close"), this);
  close->setGeometry(175, 380, 115, 30);
  connect(close, SIGNAL(clicked()), SLOT(reject()));

  lv=new QListView(this);
  if (!select)
  {
    connect(lv, SIGNAL(currentChanged(QListViewItem *)),
      SLOT(setusename(QListViewItem *)));
    connect(lv, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint &, int)),
      SLOT(showPopup(QListViewItem *, const QPoint &)));
    connect(lv, SIGNAL(returnPressed(QListViewItem *)), SLOT(usebt()));
    connect(lv, SIGNAL(doubleClicked(QListViewItem *)), SLOT(usebt()));
    connect(msg, SIGNAL(moreShown()), SLOT(reject()));
    close->setDefault(true);
  }
  lv->setGeometry(15, 15, 290, 350);
  lv->addColumn(i18n("Items"));

  while (obj)
  {
    KItemLVI *lvi=new KItemLVI(obj, lv);
    CHECK_PTR(lvi);
    obj=objnext(obj, amask);
  }
}

void KInvWnd::show()
{
  if (close!=NULL) QDialog::show();
    else 
    {
      setResult(Rejected);
      return;
    }
}

void KInvWnd::selectbt(void)
{
  KItemLVI *lvi=(KItemLVI *)lv->currentItem();
  done(lvi?lvi->obj->ichar:0);
}

void KInvWnd::setusename(QListViewItem *lvi)
{
  QString name=QString::null;
  if (lvi!=NULL)
  {
    KItemLVI *ilvi=(KItemLVI *)lvi;
    name=useName(ilvi->obj);
  }
  if (!name.isNull() && !cmdr->readOnly())
  { 
    use->setText(name);
    use->setEnabled(true);
  } else
  {
    use->setText(i18n("&Use"));
    use->setEnabled(false);
  }
}

void KInvWnd::usebt()
{
  KItemLVI *lvi=(KItemLVI *)lv->currentItem();
  done(0);
  doUse(lvi->obj);
}

int KInvWnd::getObjIconId(object *obj)
{
  switch (obj->what_is)
  {
    case ARMOR:  if (obj->is_protected) return V_GOLD;
                    else return V_ARMOR;  
    case SCROLL: return V_SCROLL;
    case POTION: return V_POTION;
    case AMULET: return V_AMULET;
    case WAND:   return V_WAND;
    case FOOD:   return V_FOOD;
    case WEAPON: return V_WEAPON;
    case RING:   return V_RING;
  }
  return 0;
}

void KInvWnd::showPopup(QListViewItem *lvi, const QPoint &pt)
{
  if (lvi==NULL) return;
  KItemLVI *ilvi=(KItemLVI *)lvi;
  KItemMenu menu(this, ilvi);
  menu.exec(pt);
}

QString KInvWnd::useName(object *obj)
{
  if (obj!=NULL)
  {
    switch (obj->what_is)
    {
      case FOOD:   return i18n("&Eat");
      case POTION: return i18n("&Quaff");
      case SCROLL: return i18n("&Read");
      case WAND:   return i18n("&Zap");
      case ARMOR:  
        if (obj->in_use_flags&BEING_WORN) return i18n("&Take off");
	  else return i18n("&Wear");
      case RING:   
        if (obj->in_use_flags&ON_EITHER_HAND) return i18n("&Remove");
	  else return i18n("&Put on");
      case WEAPON: 
        if ((obj->which_kind==ARROW) || (obj->which_kind==DART) ||
	    (obj->which_kind==DAGGER) || (obj->which_kind==SHURIKEN))
	    return i18n("&Throw"); else return i18n("&Wield");
	break;
    }
  }
  return QString::null;
}

void KInvWnd::doUse(object *obj)
{
  char c=obj->ichar;
  if (obj)
  {
    switch (obj->what_is)
    {
      case FOOD:   cmdr->eat(c);    break;
      case POTION: cmdr->quaff(c);  break;
      case SCROLL: cmdr->read(c);   break;
      case WAND:   cmdr->zap(c);    break;
      case ARMOR:  
        if (obj->in_use_flags&BEING_WORN) cmdr->takeoff();
	  else cmdr->wear(c);
	break;
      case RING:
        if (obj->in_use_flags&ON_LEFT_HAND) cmdr->lremr();
	  else if (obj->in_use_flags&ON_RIGHT_HAND) cmdr->rremr();
	    else cmdr->puton(c);
	break;
      case WEAPON:
        if ((obj->which_kind==ARROW) || (obj->which_kind==DART) ||
	    (obj->which_kind==DAGGER) || (obj->which_kind==SHURIKEN))
	    cmdr->throwsl(c); else cmdr->wield(c); 
	break;
    }  
  }
}

KItemMenu::KItemMenu(KInvWnd *_wnd, KItemLVI *_lvi)
{
  wnd=_wnd;
  lvi=_lvi;
  connect(this, SIGNAL(aboutToShow()), SLOT(fillPopup()));  
}

void KItemMenu::fillPopup(void)
{
  QString name;
  object *obj=lvi->obj;

  clear();
  name=KInvWnd::useName(obj);
  if (!name.isNull())
  {
    insertItem(name, this, SLOT(use()), 0, 1);
    insertSeparator();
  }
  if (obj->what_is&(SCROLL|POTION|WAND|RING))
    insertItem(i18n("&Call"), this, SLOT(call()), 0, 3);
  insertItem(i18n("&Drop"), this, SLOT(drop()), 0, 2);
}

void KItemMenu::use(void)
{
  wnd->done(0);
  KInvWnd::doUse(lvi->obj);
}

void KItemMenu::call(void)
{
  cmdr->call(lvi->obj->ichar);
  lvi->refresh();
  lvi->listView()->repaintItem(lvi);
}

void KItemMenu::drop(void)
{
  char item=lvi->obj->ichar;
  cmdr->drop(item);
  if (get_letter_object(item)==NULL)
    delete lvi;
}

KInvPopup::KInvPopup(int _mask, int _inusemask)
{
  mask=_mask;
  inusemask=_inusemask;
  connect(this, SIGNAL(aboutToShow()), SLOT(fillPopup()));
}

void KInvPopup::fillPopup()
{
  int item;
  object *obj;
  char str[MSGLEN];
  clear();
  if ((obj=objfirst(mask, inusemask))==NULL)
  {
    setItemEnabled(insertItem(i18n("(nothing)")), false);
    return;
  }
  do
  {
    item=KInvWnd::getObjIconId(obj);
    if (item) insertItem(*dun->itempix[item], QString::fromUtf8(objstr(obj, str)), obj->ichar);
      else insertItem(QString::fromUtf8(objstr(obj, str)), obj->ichar);
  } while ((obj=objnext(obj, mask, inusemask))!=NULL);
}

struct ItemType
{
  const char *name;
  id *idtab;
  bool showreal;
  int num, objtype;
} itemtab[]={
  {"food", NULL, false, 0, FOOD},
  {"potion", id_potions, true, POTIONS, POTION},
  {"scroll", id_scrolls, true, SCROLLS, SCROLL},
  {_T("weapon"), id_weapons, false, WEAPONS, WEAPON},
  {"armor", id_armors, false, ARMORS, ARMOR},
  {"wand", id_wands, true, WANDS, WAND},
  {"ring", id_rings, true, RINGS, RING},
  {"the amulet of Yendor", NULL, false, 0, AMULET}
};

#define nItemTypes (sizeof(itemtab)/sizeof(ItemType))

KNItemDlg::KNItemDlg(QWidget *parent)
:QDialog(parent, NULL, true)
{
  unsigned int i;
  setCaption(i18n("New item for Wizard"));
  resize(400, 295);
  QPushButton *ok=new QPushButton(i18n("&OK"), this);
  ok->setGeometry(225, 260, 80, 30);
  ok->setDefault(true);
  connect(ok, SIGNAL(clicked()), SLOT(accept()));
  QPushButton *cancel=new QPushButton(i18n("&Cancel"), this);
  cancel->setGeometry(315, 260, 80, 30);
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));
  QLabel *lab=new QLabel(i18n("Select item"), this);
  lab->setAutoResize(true);
  lab->move(15, 3);
  list1=new QListBox(this);
  list1->setGeometry(5, 20, 135, 230);
  list2=new QListBox(this);
  list2->setGeometry(145, 20, 250, 230);
  for (i=0; i<nItemTypes; i++)
    list1->insertItem(i18n(itemtab[i].name));
  list1->setFocus();
  connect(list1, SIGNAL(highlighted(int)), SLOT(listclick(int)));
}

void KNItemDlg::listclick(int i)
{
  list2->clear();
  if (!itemtab[i].idtab)
  {
    list2->setEnabled(false);
    list2->insertItem("("+list1->text(i)+")");
    return;
  }
  int j;
  list2->setEnabled(true);
  for (j=0; j<itemtab[i].num; j++)
    if (itemtab[i].showreal)
      list2->insertItem(i18n(itemtab[i].idtab[j].real));
      else list2->insertItem(i18n(itemtab[i].idtab[j].title));
}

void KNItemDlg::accept()
{
  object *obj=alloc_object();
  int t=list1->currentItem(), k;
  if (t==-1) t=0;
  obj->what_is=itemtab[t].objtype;
  if (t==0) get_food(obj, 0);
  if (itemtab[t].idtab)
  {
    k=list2->currentItem();
    if (k==-1) k=0;
    obj->which_kind=k;
    if (t==3) gr_weapon(obj, 0);
    if (t==4) gr_armor(obj, 0);
    if (t==5) gr_wand(obj, 0);
    if (t==6) gr_ring(obj, 0);
  }
  char buf[MSGLEN];
  get_desc(obj, buf);
  message(buf, 0);
  add_to_pack(obj, &rogue.pack, 1);
  QDialog::accept();
}

KStrDlg::KStrDlg(const QString &question, bool pass, QWidget *parent, char *name)
:QDialog(parent, name, true)
{
  setFixedSize(430, 65);
  setCaption(i18n("Rogue"));
  le=new QLineEdit(this);
  le->setGeometry(2, 30, 340, 27);
  QLabel *label=new QLabel(le, question, this);
  label->setGeometry(2, 7, 340, 17);
  QPushButton *pb=new QPushButton(i18n("&OK"), this);
  pb->setGeometry(350, 3, 75, 27);
  pb->setDefault(true);
  connect(pb, SIGNAL(clicked()), SLOT(accept()));
  pb=new QPushButton(i18n("&Cancel"), this);
  pb->setGeometry(350, 35, 75, 27);
  connect(pb, SIGNAL(clicked()), SLOT(reject()));
  if (pass) le->setEchoMode(QLineEdit::Password);
  le->setFocus();
}

KSellItemDlg::KSellItemDlg(QWidget *parent, char *name)
:QDialog(parent, name, true)
{
  setFixedSize(350, 450);
  setCaption(i18n("Rogue"));

  lv=new QListView(this);
  lv->setGeometry(15, 15, 320, 390);
  lv->addColumn(i18n("Item"), 240);
  lv->addColumn(i18n("Value"), 70);
  lv->setSorting(-1);

  QPushButton *pb=new QPushButton(i18n("&OK"), this);
  pb->setDefault(true);
  pb->setGeometry(130, 415, 90, 27);
  connect(pb, SIGNAL(clicked()), SLOT(accept()));
  egold=rogue.gold;
  lastlvi=NULL;
}

void KSellItemDlg::add(const QString &name, int price)
{
  QListViewItem *lvi=new QListViewItem(lv, lastlvi, name,
    QString::number(price));
  CHECK_PTR(lvi);
  lastlvi=lvi;
}


void KSellItemDlg::show()
{
  QListViewItem *lvi=new QListViewItem(lv, lastlvi);
  CHECK_PTR(lvi);
  lvi=new QListViewItem(lv, lvi, i18n("Total"),
    QString::number(rogue.gold-egold));
  CHECK_PTR(lvi);
  QDialog::show();
}
