/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SAVEDIALOG_H
#define SAVEDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdialog.h>

#include <qwidget.h>
#include <qcheckbox.h>
#include <qmultilineedit.h>
#include <qlabel.h>
#include <qlayout.h>

class CSaveDialog : public QDialog
{
        Q_OBJECT
 public:
	CSaveDialog(QWidget* parent, bool savePixmap);
	virtual ~CSaveDialog();

	// Data
 public:
	bool savePixmap() const { return _savePixmap->isChecked(); }
        QString annotation() const { return _annotation->text(); }

 protected:
        QVBoxLayout* _vbox;
        QHBoxLayout* _hbox;

        QLabel* _annLabel;
        QMultiLineEdit* _annotation;
	QCheckBox* _savePixmap;

 protected slots:
        void slotHelp();
};

#endif // GAMEDIALOG_H
