/***************************************************************************
                          midata.cpp  -  description
                             -------------------
    begin                : Wed Nov 14 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <qarray.h>

 #include "tree.h"

#include "midata.h"


MiData::MiData() {
	matriz = Matrix<int> (7,7) ;
}

MiData::MiData(MiData &data)  {
	matriz = Matrix<int> (7,7) ;
	int i, j ;
	
	for (i=0; i<7; i++)
		for (j=0; j<7; j++)
				set(i,j, data.matriz.get(i,j)) ;
	set_g(data.get_g()) ;
	set_h(data.get_h()) ;	

	start_x = data.start_x ;
	start_y = data.start_y ;
	end_x = data.end_x ;
	end_y = data.end_y ;
}

int MiData::calculate_h() {
	int i, j ;
	int suma = 0 ;
	
	for (i=0; i<7; i++) {
		for (j=0; j<7; j++) {
			if (posicionValida(i, j) && get(i,j) == Ocupada) {
				if ((i == 0) || (i == 6) || (j == 0) ||  (j == 6))
					suma = suma + 7 ;
				else if ( (i == 1) || (j == 1) || (i == 5) || (j==5) )
					suma = suma + 1 ;
				else if ( (i == 2) || (j == 2) || (i == 4) || (j==4) )
					suma = suma + 1 ;
				else
					suma = suma + 0 ;
			}
		}
	}
	return (suma) ;
}

Tree<AStarData> *MiData::sucesors(void) {
	Tree<AStarData> *lista;
	MiData *aux ;
		
	int i, j, orientacion;
	int a, b, c, d ;
	
	/* BUG:	lista = new Tree<MiData>() ; */
	lista = null ;
	
	for (i = 0; i< 7; i++)
		for (j= 0; j< 7; j++)
			if (posicionValida(i, j) )
				if (get(i,j) == Ocupada)
					for (orientacion = 0; orientacion < 4; orientacion++)
					{
						switch (orientacion)
						{
							case Norte:
								a = 0; b = -1; c = 0 ; d = -2 ;
								break ;
							case Sur:
								a = 0; b = 1; c = 0; d = 2 ;
								break ;
							case Este:
								a = -1; b = 0; c = -2; d = 0;
								break ;
							case Oeste:
								a = 1; b = 0; c = 2; d=0 ;
								break ;
						}
						if (posicionValida(i+a, j+b) && posicionValida(i+c, j+d) )
							if (get(i+a, j+b) == Ocupada && get(i+c, j+d) == Vacia) {
								aux = new MiData(*this) ;
								aux->set(i, j, Vacia) ;
								aux->set(i+a, j+b, Vacia) ;
								aux->set(i+c, j+d, Ocupada) ;
								aux->set_g (get_g() + 1)  ;
								aux->start_x = i ;
								aux->start_y = j ;
								aux->end_x = i+c ;
								aux->end_y = j+d ;
								/* BUG: calculaba h sobre this, el padre, no sobre el nuevo nodo */
								aux->set_h(aux->calculate_h()) ;
								if (lista == null) {
									lista = new Tree<AStarData>(aux) ;
								} else {
									lista->insertBrother(aux) ;
								}
								/* DEBUG aux->print() ; */
							}
					}
	return (lista) ;
} /* MiData::sucesors */

int MiData::get(int i, int j) {
	return matriz.get(i, j) ;
}

void MiData::set(int i, int j, int data) {
	matriz.set(i, j, data) ;
}

bool MiData::isGoal(void) {
	return (get_h() == 0) ;
}

bool MiData::posicionValida(int i, int j) {
	if ( i>1 && i<5)
		return (j>=0 && j<=6) ;
	if ( j>1 && j<5)
		return (i>=0 && i<=6) ;
	return false ;
}

void MiData::init(void) {
	int i, j ;
	
	for (i=0; i<7; i++)
		for (j=0; j<7; j++)
			if (posicionValida(i,j))
				if (i == 3 && j == 3) /* posicion central vacia */
					matriz.set(i,j, Vacia) ;
				else
					matriz.set(i,j, Ocupada) ;
			else
				matriz.set(i, j, None) ;
	set_g(0) ;
	set_h(calculate_h()) ;
}

Matrix<int> MiData::get_matriz() {
	return matriz ;
}

bool MiData::isEqual(MiData data2) {
	return (
		(this->get_matriz()).isEqual(data2.get_matriz() )
	) ;
}


void MiData::print() {
	matriz.print() ;
	cout << "g + h = f : "  << get_g() << " + " << get_h() <<  " = " << get_g()+get_h() << endl <<endl ;
}

MiData::~MiData() {
}
