/***************************************************************************
                          tree.h  -  description
                             -------------------
    begin                : Wed Nov 14 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TREE_H
#define TREE_H

#include <qarray.h>

/**
  *@author Jos?Pablo Fern?dez
  */

#define null 0

template<class type>
class Tree {
public: 
	Tree() {
		padre = null ;
		hijo = null ;
		hermano = null ;
		the_data = null ;
	}

	Tree(type *data) {
		Tree::the_data = data ;
		padre = null ;
		hijo = null ;
		hermano = null ;
	}	
	
	~Tree() {
		if (the_data != null) delete (the_data) ;
		if (hijo != null) delete (hijo) ;
		if (hermano != null) delete (hermano) ;
	} /* necesario ? */
	
	void insertBrother(type *data) {
		Tree *aux ;
		aux = new Tree(data) ;
		aux->padre = Tree::padre ;
		aux->hijo = null ;
		aux->hermano = Tree::hermano ;
		Tree::hermano = aux ;
	}
	
	void insertSons(Tree *sons) {
		Tree *aux ;		
		Tree::hijo = sons ;
		if  (sons == null) /* necesario ? */
			return ;
		
		for (aux = sons; aux != null; aux = aux->hermano) {
				aux->padre = this ;
		}
	}
	
	type *data() {	return the_data ;	}
	Tree *son() { return hijo ; }
	Tree *brother() { return hermano; }
	Tree *parent() { return padre ; }	
	Tree *next() {
		if (hijo != null)
			return hijo;
		else if (hermano != null)
			return hermano ;
		else if (padre == null)
			return null ;
		else
			return (padre->next()) ;
		}


	
private:
	type  *the_data ;
	Tree *padre ;
	Tree *hijo ;
	Tree *hermano ;
};

#endif
