/***************************************************************************
                          cmaptoolselect.cpp
                      -------------------
    description          :
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cmaptoolselect.h"


CMapToolSelect::CMapToolSelect(CMapData *mapData,CMapWidget *map,int id, QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu) : CMapToolBase(mapData,map,id,name,icon,toolBar,menu)
{
	pathEditing = NULL;
	pointEditing = -1;
	bDragging = false;
	connect (&mouseDownTimer ,SIGNAL(timeout()),SLOT(slotStartDraging()));
}

CMapToolSelect::~CMapToolSelect()
{
}

/** This method is called when the mouse is pressed */
void CMapToolSelect::mousePressEvent(QMouseEvent *e)
{
	pathEditing = NULL;	
	moveDrag = false;		

	for (CMapElement *element=elementList->first(); element !=0; element =elementList->next())
	{
		if (element->mouseInResize(e->x(),e->y(),mapWidget->getCurrentZone()))
		{			
			mapWidget->changeStatusBar(i18n("Drag the element a new position"));
			moveDrag = true;			
		}	
		else
		{
			if (element->getElementType()==PATH)
			{
				if (element->getEditMode())
				{
					pathEditing=(CMapPath*)element;
					pointEditing = pathEditing->elementInEditBox(e->x(),e->y(),mapWidget->getCurrentZone());
					if (pointEditing != -1)
					{
						pathEditing = (CMapPath *)element;
						break;
					}
				}
			}		
		}
	}
		
	if (moveDrag)
	{
		mouseDragX =  e->x();
		mouseDragY =  e->y();
		lastDragX = -100;
		lastDragY = -100;
	}
	else
	{
		mouseDragX = lastDragX = e->x();
		mouseDragY = lastDragY = e->y();
	}	
	
	mouseDownTimer.start(150,false);
}

/** This method is called when the mouse is released */
void CMapToolSelect::mouseReleaseEvent(QMouseEvent *e)
{
	bool found = false;
	CMapElement *element;
	QScrollView *mapView = mapWidget->getMapView();

	if (mapWidget->getViewOverview() && !(bDragging) &&
	    mapWidget->width()>180 && mapWidget->height()>100)
	{
		int view_x,view_y;
		if (mapView->viewport()->width()>mapView->contentsWidth())
			view_x =mapView->contentsWidth();
		else
			view_x =mapView->viewport()->width();

		if (mapView->viewport()->height()>mapView->contentsHeight())
			view_y =mapView->contentsHeight();
		else
			view_y =mapView->viewport()->height();

		if (e->x()>=mapView->contentsX()+view_x-180 &&
			e->x()<=mapView->contentsX()+view_x &&
            		e->y()>=mapView->contentsY()+view_y-100 &&
	                e->y()<=mapView->contentsY()+view_y)
		{
			return;			
		}
	}

	mouseDownTimer.stop();

	if (bDragging)
	{
		if (moveDrag)
		{
			moveElement(e);
		}
		else if (pathEditing && pointEditing >-1)
		{
			movePathEditPoint(e);
		}
		else
		{		
			found = false;

			if (!mapWidget->getCtrlPressed())
			{
				found = mapWidget->unselectAll();
			}

			for (element=elementList->first(); element !=0; element =elementList->next())
			{			
				if (element->elementIn(mouseDragX,mouseDragY,lastDragX,lastDragY,mapWidget->getCurrentZone()))
				{			
					element->setSelected(true);		
					found = true;
				}
			}

			// Erase old rectangle		
			dragPainter.begin(mapWidget);
			dragPainter.setPen(black);
			dragPainter.setRasterOp(NotROP);
			dragPainter.drawRect(mouseDragX,mouseDragY,lastDragX-mouseDragX,lastDragY-mouseDragY);
			dragPainter.end();

			mapWidget->redraw();
		}
			
		bDragging = false;
		return;
	}

	// Check to see if the context menu needs displaying
	if (e->button()==LeftButton)
	{
		for (element=elementList->first(); element !=0; element =elementList->next())
		{
			if (element->mouseInElement(e->x(),e->y(),mapWidget->getCurrentZone()))
			{				
				if (element->getSelected())
				{				
					if (!mapWidget->getCtrlPressed())
					{

						mapWidget->unselectAll();

						element->setEditMode(true);
					}
				
					element->setSelected(false);
					
				}
				else	
				{	
					if (!mapWidget->getCtrlPressed())
					{
						if (!found) mapWidget->unselectAll();			
					}

					element->setSelected(true);
					
				}
		
				found = true;					
			}
		}

		if (!found)
			mapWidget->unselectAll();

	}
	mapWidget->redraw();
	
}

/** This method is called when the mouse is moved */
void CMapToolSelect::mouseMoveEvent(QMouseEvent *e)
{
	int x,y,offsetx,offsety;

	if (!bDragging) return;

	x=e->x();
	y=e->y();

	if (lastDragX != x || lastDragY !=y)
	{
		dragPainter.begin(mapWidget);
	
		dragPainter.setPen(black);

		dragPainter.setRasterOp(NotROP);

		if (moveDrag)
		{		
			dragPainter.setRasterOp(NotROP);
			
			offsetx = (((int)(x / ROOM_SIZE)) * ROOM_SIZE) - (((int)((mouseDragX-6)/ROOM_SIZE))*ROOM_SIZE)-ROOM_SIZE;
			offsety = (((int)(y / ROOM_SIZE)) * ROOM_SIZE) - (((int)((mouseDragY-6)/ROOM_SIZE))*ROOM_SIZE)-ROOM_SIZE;			

			for (CMapElement *element=elementList->first(); element !=0; element =elementList->next())
			{
				if (element->getSelected())
				{
					element->dragPaint(&dragPainter,offsetx,offsety,mapWidget->getCurrentZone());
				}
			}

			offsetx = (((int)(lastDragX / ROOM_SIZE)) * ROOM_SIZE) - (((int)((mouseDragX-6)/ROOM_SIZE))*ROOM_SIZE)-ROOM_SIZE;
			offsety = (((int)(lastDragY / ROOM_SIZE)) * ROOM_SIZE) - (((int)((mouseDragY-6)/ROOM_SIZE))*ROOM_SIZE)-ROOM_SIZE;		
						
			for (CMapElement *element=elementList->first(); element !=0; element =elementList->next())
			{
				if (element->getSelected())
				{
					element->dragPaint(&dragPainter,offsetx,offsety,mapWidget->getCurrentZone());
				}
			}

		}
		else if (pathEditing && pointEditing >-1)
		{
			dragPainter.setRasterOp(NotROP);
			offsetx = x - (mouseDragX);
			offsety = y - (mouseDragY);			
        	
			pathEditing->dragEditPaint(&dragPainter,offsetx,offsety,pointEditing,mapWidget->getCurrentZone());

			offsetx = lastDragX - (mouseDragX);
			offsety = lastDragY - (mouseDragY);			
							
			pathEditing->dragEditPaint(&dragPainter,offsetx,offsety,pointEditing,mapWidget->getCurrentZone());

		}	
		else
		{			
			// Erase old rectangle
			dragPainter.drawRect(mouseDragX,mouseDragY,lastDragX-mouseDragX,lastDragY-mouseDragY);

			// Draw new rectangle
			dragPainter.drawRect(mouseDragX,mouseDragY,x-mouseDragX,y-mouseDragY);
			
		}
		
		lastDragX=x;
		lastDragY=y;

		dragPainter.end();
	}
}

/** This function called when the select tool is selected */
void CMapToolSelect::toolSelected(void)
{
	bDragging = false;
	
	mapWidget->setCursor(arrowCursor);	
	mapWidget->setMouseTracking(false);
	menu->setItemChecked(id,true);	
	toolsToolbar->setButton(id,true);	
}
	
/** This function is called when the select tool is unselected */
void CMapToolSelect::toolUnselected(void)
{
	menu->setItemChecked(id,false);	
	toolsToolbar->setButton(id,false);	

	if (mapWidget->unselectAll())
	{
		mapWidget->redraw();
	}

}

void CMapToolSelect::movePathEditPoint(QMouseEvent *e)
{
	if (pathEditing)
	{
		pathEditing->moveBend(pointEditing,e->x(),e->y());		
		
		if (pathEditing->getOpsitePath())
			pathEditing->getOpsitePath()->moveBend(pointEditing,e->x(),e->y());		

		mapWidget->redraw();
		
		pathEditing = NULL;
		pointEditing = -1;
	}
}

/** This function is used to move a element to a new position */
void CMapToolSelect::moveElement(QMouseEvent *e)
{
	CMapRoom *room;

	moveDrag = false;

	int offsetx = (((int)(e->x() / ROOM_SIZE)) * ROOM_SIZE) - (((int)((mouseDragX-6)/ROOM_SIZE))*ROOM_SIZE)-ROOM_SIZE;
	int offsety = (((int)(e->y() / ROOM_SIZE)) * ROOM_SIZE) - (((int)((mouseDragY-6)/ROOM_SIZE))*ROOM_SIZE)-ROOM_SIZE;

	for (CMapElement *element=elementList->first(); element !=0; element =elementList->next())
	{
		if (element->getSelected())
		{
			CMapRoom *findRoom;
			CMapPath *path;
			switch (element->getElementType())
			{
				case ROOM:  findRoom = mapWidget->findRoomAt(((CMapRoom *)element)->getX() + (offsetx / ROOM_SIZE),
				                                           ((CMapRoom *)element)->getY() + (offsety / ROOM_SIZE),
				                                           mapWidget->getCurrentLevel(),mapWidget->getCurrentZone());
				
							if (findRoom)
								if (findRoom->getSelected()) findRoom = NULL;
					
							if (!findRoom)
							{
								room=(CMapRoom *)element;
								room->moveBy(offsetx,offsety);					
								
								for (path=room->connectingPaths.last(); path!=0; path = room->connectingPaths.prev())
								{		
									path->setLowHiX(path->getLowX(),path->getHiX()+offsetx);
									path->setLowHiY(path->getLowY(),path->getHiY()+offsety);
								}
							
								for (path=room->pathList.last(); path!=0; path = room->pathList.prev())
								{					
									path->setLowHiX(path->getLowX()+offsetx,path->getHiX());
									path->setLowHiY(path->getLowY()+offsety,path->getHiY());
								}
							}
							break;
				case PATH:  path=(CMapPath *)element;
							if (path->getSrcRoom()->getSelected() && path->getDestRoom()->getSelected())
								path->moveBy(offsetx,offsety);
							break;
							
				
				default: element->moveBy(offsetx,offsety); break;
			}	
		}
	}	
		
	mapWidget->redraw();
}

///////////////////////////////////// SLOTS /////////////////////////////////////////////////

void CMapToolSelect::slotStartDraging(void)
{
	bDragging = true;
	mouseDownTimer.stop();
}

