/***************************************************************************
                          dlgmapspeedwalk.h
                      -------------------
    description          :
    begin                : Thu Jan 18 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGMAPSPEEDWALK_H
#define DLGMAPSPEEDWALK_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qpushbutton.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qwidget.h>

#include "../cmaproom.h"
#include "../cmapdata.h"
#include "../cmapwidget.h"

struct SpeedwalkElement
{	
		QString name;
		int count;
};

/**
  *@author John-Paul Stanford
  */

class DlgMapSpeedwalk : public QWidget  {
   Q_OBJECT
public: 
	DlgMapSpeedwalk(CMapWidget *mWidget,CMapData *data,QWidget *parent=0, const char *name=0);
	~DlgMapSpeedwalk();
	
protected:
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QLabel *lblCategorize;
	QComboBox *cboCategorize;
	QLabel *QLabel_1;
	QListView *lstSpeedwalk;
	QPushButton *cmdDelete;
	QPushButton *cmdSpeedwalk;
	QPushButton *cmdProperties;	
	//Generated area. DO NOT EDIT!!!(end)
	
	void resizeEvent(QResizeEvent *e);	

signals:
	void resizeSpeedwalk(int);
	
private:
	QList<SpeedwalkElement> roomLevel;
	QList<SpeedwalkElement> zoneLevel;

	CMapWidget *mapWidget;
	CMapData *mapData;
	/** Used to find out which level a item is at */
	signed int getLevelOfItem(QListViewItem *item);	
	/* Used to get the room name */
	QString getRoomName(CMapRoom *room);
	/** Used to find the zone for the zone/room catogery */
	QListViewItem *findZone(CMapRoom *room);
	/** Used to find the level for the zone/level/room catogery */
	QListViewItem *findLevel(CMapRoom *room);
	/** Used to get the zone name and get correct name for unamed zones */
	QString getZoneName(CMapZone *zone);
	/** Used to count the number of times a elements in a given level list*/
	int countElements(QList<SpeedwalkElement> *lstLevel,QString element);
   	/** Get the room of a given item */
    CMapRoom *getRoom(QListViewItem *current);
    /** Used to delete a room from the speedwalk list */
	bool deleteRoom(QListViewItem *roomItem);
	/** Delete all the elements based on the level and zone */
	bool deleteLevel(QListViewItem *item);
	/** Delete all the elements based on the zone */
	bool deleteZone(QListViewItem *item);
	

public slots:
	/** Used to display the speed walk list */
	void updateSpeedwalkList(CMapRoom *updatedRoom);
	
protected slots:	
	/** Used to display the speed walk list */
	void updateSpeedwalkList(void);
	/** This slot is called when the delete button is pressed */
	void slotDelete(void);
	/** This slot is called when the delete button is pressed */
	void slotSpeedwalk(void);	
	/** This is used to dislpay the room properties dialog */
	void slotProperties(void);
  /** slot for double click events on the list view */
  void slotDoubleClicked(QListViewItem* item);
	
};

#endif
