/***************************************************************************
                          cmaptoolselect.h
                      -------------------
    description          :
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPTOOLSELECT_H
#define CMAPTOOLSELECT_H

#include <qpainter.h>
#include <qtimer.h>

#include "cmaptoolbase.h"



/** The tool is used to select the objects and while they are selected,
  * the cut / copy / paste and delete operaions can be performed on
  * elements. It is also posible to move elements while they are selected
  * and this mode is active.
  * @author John-Paul Stanford
  */
class CMapToolSelect : public CMapToolBase
{
Q_OBJECT
public:
	CMapToolSelect(CMapData *data,CMapWidget *map,int id, QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu);
	~CMapToolSelect();
		
	/** This method is called when the mouse is pressed */
	void mousePressEvent(QMouseEvent *e);
	/** This method is called when the mouse is pressed */
	void mouseReleaseEvent(QMouseEvent *e);
	/** This method is called when the mouse is moved */
	void mouseMoveEvent(QMouseEvent *e);
	/** This function called when the select tool is selected */
	void toolSelected(void);
	/** This function is called when the select tool is unselected */
	void toolUnselected(void);
	/** This function is used to move a element to a new position */
	void moveElement(QMouseEvent *e);
	void movePathEditPoint(QMouseEvent *e);
public slots:
	void slotStartDraging(void);
	
private:	
	CMapPath *pathEditing;
	signed int pointEditing;
	/** Used to paint by the move events */
	QPainter dragPainter;
	/** Is a room being moved by dragging */
	bool moveDrag;
	/** Used to mesure how long a mouse putton is held down */
	QTimer mouseDownTimer;
	/** Used to tell if the mouse is being draged */	
	bool bDragging;
	/** Uses to store the current pos for dragging positions */
	int mouseDragX,mouseDragY;
	/** Used to store the last mouse pos for dragging positions */
	int lastDragX,lastDragY;

};

#endif
