/*
 * KMLOFax
 *
 * A utility to process facsimiles received with the ELSA
 * MicroLink(tm) Office or MicroLink(tm) ISDN Office modem.
 *
 * Copyright (C) 1999-2001 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen.
 */

#include <stdlib.h>

#include <kuniqueapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include <qnamespace.h>

#include "kmlofax.h"


static const char *description =
	I18N_NOOP("A facsimile utility for the ELSA MicroLink(tm) Office and the\nELSA MicroLink(tm) ISDN Office modem.");
	
	
int main(int argc, char *argv[])
{
	KAboutData aboutData("kmlofax", I18N_NOOP("KMLOFax"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 1999-2001, Oliver Gantz",
		I18N_NOOP("ELSA and MicroLink are trademarks of ELSA AG, Aachen."),
		"http://www.tu-bs.de/~y0000441/kmlofax.html",
		"Oliver.Gantz@ePost.de");
	aboutData.addAuthor("Oliver Gantz", 0, "Oliver.Gantz@ePost.de");
	KCmdLineArgs::init(argc, argv, &aboutData);

	if (!KUniqueApplication::start())
		exit(0);

	KMLOFaxApp a;
	KMLOFax *kmlofax = new KMLOFax(0, "mainwindow");
	CHECK_PTR(kmlofax);
	a.setMainWidget(kmlofax);
	kmlofax->setCaption(QString::null);

	return a.exec();
}
