/*
   SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "textautogeneratewidgetgui.h"
using namespace Qt::Literals::StringLiterals;

#include "textautogeneratetext/textautogeneratedialog.h"
#include <QHBoxLayout>
#include <QPushButton>

TextAutoGenerateWidgetGui::TextAutoGenerateWidgetGui(QWidget *parent)
    : QWidget{parent}
{
    auto mainLayout = new QHBoxLayout(this);
    mainLayout->setContentsMargins({});
    auto showGenerateDialogButton = new QPushButton(u"Show Dialog..."_s, this);
    mainLayout->addWidget(showGenerateDialogButton, 0, Qt::AlignTop);
    connect(showGenerateDialogButton, &QPushButton::clicked, this, [this]() {
        TextAutoGenerateText::TextAutoGenerateDialog d(this);
        d.exec();
    });
}

TextAutoGenerateWidgetGui::~TextAutoGenerateWidgetGui() = default;

#include "moc_textautogeneratewidgetgui.cpp"
