/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
import QtQuick 2.0
import QtQuick.Controls 1.0
import QtQuick.Layouts 1.0

RowLayout {
    id: grid
    property var m: report.categories_period
    property var max: maxValues(m)
    spacing: 2

    function maxValues(m) {
        var output = -1
        for (var i = 1; i < m.length; i++) {
            if (m[i][2] > output)
                output = m[i][2]
        }
        return output
    }

    ColumnLayout {
        spacing: 0

        // Set titles
        Repeater {
            model: m
            Label {
                Layout.fillWidth: true
                font.bold: index == 0
                text: index == 0 ? modelData[1] : index + ": " + modelData[1]
                horizontalAlignment: index == 0 ? Text.AlignHCenter : Text.AlignLeft
            }
        }
    }

    ColumnLayout {
        spacing: 0

        // Set values
        Repeater {
            model: m
            SKGValue {
                Layout.fillWidth: true
                horizontalAlignment: index == 0 ? Text.AlignHCenter : Text.AlignRight
                font.bold: index == 0

                value: index == 0 ? null : modelData[2]
                max: grid.max
                text: index == 0 ? modelData[2] : document.formatPrimaryMoney(
                                       modelData[2])
                backgroundColor: '#' + color_negativetext
                url: index == 0 ? "" : "skg://Skrooge_operation_plugin/SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/?operationTable=v_suboperation_consolidated&operationWhereClause="
                                  + modelData[3] + "&title=" + modelData[1] + "/"
                                  + m[0][2] + "&title_icon=view-categories"
            }
        }
    }
}
