/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <https://www.gnu.org/licenses/>  *
 ***************************************************************************/
import QtQuick 2.0
import QtQuick.Layouts 1.0
import QtQuick.Controls 1.0

GridLayout {
    id: widget
	columns: 2

	property double maxValue: Math.max(incomes1Bar.value, expenditures1Bar.value, incomes2Bar.value, expenditures2Bar.value)
        property double totrigger: 1.0
        
        Connections {
            target: report
            onChanged: {
                totrigger = 2.0; 
                totrigger = 1.0;
            }
        }
        
	Label{
		id: label1
		text: period1Widget.text
		font.bold: true
		font.pixelSize: report.point_size
		Layout.columnSpan: 2
	}
	
	Label{
		text: qsTr("Incomes:")
                font.pixelSize: report.point_size
	}

	SKGValue {
		id: incomes1Bar
		max: parent.maxValue
		value: totrigger*report.getIncomeVsExpenditure(suboperationsWidget.checked, groupedWidget.checked, transferWidget.checked, trackerWidget.checked, period1Widget.whereClause, period2Widget.whereClause)[1][3]
		text: document.formatPrimaryMoney(value)
		horizontalAlignment: Text.AlignHCenter
		backgroundColor: '#' + color_positivetext
		url: "skg://skrooge_operation_plugin/" + (suboperationsWidget.checked ? "SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/" :"") + "?operationTable=" +
        (suboperationsWidget.checked ? "v_suboperation_consolidated": "v_operation_display") + "&title_icon=view-bank-account-savings&currentPage=-1&title=" +
		qsTr("Incomes of %1").arg(label1.text) +
                "&operationWhereClause=" + period1Widget.whereClause + " AND t_TYPEACCOUNT<>'L' AND t_TYPEEXPENSE='+'" +
		(groupedWidget.checked ? "" : " AND i_group_id=0") + (transferWidget.checked ? "" : " AND t_TRANSFER='N'") + (trackerWidget.checked ? "" : (suboperationsWidget.checked ? " AND t_REALREFUND=''" :  " AND t_REFUND=''"));
	}

	Label{
		text: qsTr("Expenditures:")
                font.pixelSize: report.point_size
	}

	SKGValue {
		id: expenditures1Bar
		max: parent.maxValue
		value: totrigger*report.getIncomeVsExpenditure(suboperationsWidget.checked, groupedWidget.checked, transferWidget.checked, trackerWidget.checked, period1Widget.whereClause, period2Widget.whereClause)[2][3]
		text: document.formatPrimaryMoney(value)
		horizontalAlignment: Text.AlignHCenter
		backgroundColor: '#' + color_negativetext
		url: "skg://skrooge_operation_plugin/" + (suboperationsWidget.checked ? "SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/" :"") + "?operationTable=" +
        (suboperationsWidget.checked ? "v_suboperation_consolidated": "v_operation_display") + "&title_icon=view-bank-account-savings&currentPage=-1&title=" +
		qsTr("Expenses of %1").arg(label1.text) +
                "&operationWhereClause=" + period1Widget.whereClause + " AND t_TYPEACCOUNT<>'L' AND t_TYPEEXPENSE='-'" +
		(groupedWidget.checked ? "" : " AND i_group_id=0") + (transferWidget.checked ? "" : " AND t_TRANSFER='N'") + (trackerWidget.checked ? "" : (suboperationsWidget.checked ? " AND t_REALREFUND=''" :  " AND t_REFUND=''"));		
	}
	
	Label{
		text: qsTr("Savings:")
                font.pixelSize: report.point_size
	}

	SKGValue {
		id: savings1Bar
		max: parent.maxValue
		value: Math.abs(incomes1Bar.value - expenditures1Bar.value)
		text: document.formatPrimaryMoney(incomes1Bar.value - expenditures1Bar.value)
		horizontalAlignment: Text.AlignHCenter
		backgroundColor: '#' + (incomes1Bar.value - expenditures1Bar.value <0 ? color_negativetext : color_positivetext)
		url: "skg://skrooge_operation_plugin/" + (suboperationsWidget.checked ? "SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/" :"") + "?operationTable=" +
        (suboperationsWidget.checked ? "v_suboperation_consolidated": "v_operation_display") + "&title_icon=view-bank-account-savings&currentPage=-1&title=" +
		qsTr("Savings of %1").arg(label1.text) +
                "&operationWhereClause=" + period1Widget.whereClause + " AND t_TYPEACCOUNT<>'L'" +
		(groupedWidget.checked ? "" : " AND i_group_id=0") + (transferWidget.checked ? "" : " AND t_TRANSFER='N'") + (trackerWidget.checked ? "" : (suboperationsWidget.checked ? " AND t_REALREFUND=''" :  " AND t_REFUND=''"));			
	}
	
	
	Label{
		id: label2
		text: period2Widget.text
		font.bold: true
		font.pixelSize: report.point_size
		Layout.columnSpan: 2
	}
	
	Label{
		text: qsTr("Incomes:")
                font.pixelSize: report.point_size
	}

	SKGValue {
		id: incomes2Bar
		max: parent.maxValue
		value: totrigger*report.getIncomeVsExpenditure(suboperationsWidget.checked, groupedWidget.checked, transferWidget.checked, trackerWidget.checked, period1Widget.whereClause, period2Widget.whereClause)[1][2]
		text: document.formatPrimaryMoney(value)
		horizontalAlignment: Text.AlignHCenter
		backgroundColor: '#' + color_positivetext
		url: "skg://skrooge_operation_plugin/" + (suboperationsWidget.checked ? "SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/" :"") + "?operationTable=" +
        (suboperationsWidget.checked ? "v_suboperation_consolidated": "v_operation_display") + "&title_icon=view-bank-account-savings&currentPage=-1&title=" +
		qsTr("Incomes of %1").arg(label2.text) +
                "&operationWhereClause=" + period2Widget.whereClause + " AND t_TYPEACCOUNT<>'L' AND t_TYPEEXPENSE='+'" +
		(groupedWidget.checked ? "" : " AND i_group_id=0") + (transferWidget.checked ? "" : " AND t_TRANSFER='N'") + (trackerWidget.checked ? "" : (suboperationsWidget.checked ? " AND t_REALREFUND=''" :  " AND t_REFUND=''"));		
	}

	Label{
		text: qsTr("Expenditures:")
                font.pixelSize: report.point_size
	}

	SKGValue {
		id: expenditures2Bar
		max: parent.maxValue
		value: totrigger*report.getIncomeVsExpenditure(suboperationsWidget.checked, groupedWidget.checked, transferWidget.checked, trackerWidget.checked, period1Widget.whereClause, period2Widget.whereClause)[2][2]
		text: document.formatPrimaryMoney(value)
		horizontalAlignment: Text.AlignHCenter
		backgroundColor: '#' + color_negativetext
		url: "skg://skrooge_operation_plugin/" + (suboperationsWidget.checked ? "SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/" :"") + "?operationTable=" +
        (suboperationsWidget.checked ? "v_suboperation_consolidated": "v_operation_display") + "&title_icon=view-bank-account-savings&currentPage=-1&title=" +
		qsTr("Expenses of %1").arg(label2.text) +
                "&operationWhereClause=" + period2Widget.whereClause + " AND t_TYPEACCOUNT<>'L' AND t_TYPEEXPENSE='-'" +
		(groupedWidget.checked ? "" : " AND i_group_id=0") + (transferWidget.checked ? "" : " AND t_TRANSFER='N'") + (trackerWidget.checked ? "" : (suboperationsWidget.checked ? " AND t_REALREFUND=''" :  " AND t_REFUND=''"));			
	}
	
	Label{
		text: qsTr("Savings:")
                font.pixelSize: report.point_size
	}

	SKGValue {
		id: savings2Bar
		max: parent.maxValue
		value: Math.abs(incomes2Bar.value - expenditures2Bar.value)
		text: document.formatPrimaryMoney(incomes2Bar.value - expenditures2Bar.value)
		horizontalAlignment: Text.AlignHCenter
		backgroundColor: '#' + (incomes2Bar.value - expenditures2Bar.value <0 ? color_negativetext : color_positivetext)
		url: "skg://skrooge_operation_plugin/" + (suboperationsWidget.checked ? "SKGOPERATION_CONSOLIDATED_DEFAULT_PARAMETERS/" :"") + "?operationTable=" +
        (suboperationsWidget.checked ? "v_suboperation_consolidated": "v_operation_display") + "&title_icon=view-bank-account-savings&currentPage=-1&title=" +
		qsTr("Savings of %1").arg(label2.text) +
                "&operationWhereClause=" + period2Widget.whereClause + " AND t_TYPEACCOUNT<>'L'" +
		(groupedWidget.checked ? "" : " AND i_group_id=0") + (transferWidget.checked ? "" : " AND t_TRANSFER='N'") + (trackerWidget.checked ? "" : (suboperationsWidget.checked ? " AND t_REALREFUND=''" :  " AND t_REFUND=''"));		
	}	
	
}
