/*
   SPDX-FileCopyrightText: 2016-2021 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef CHECKBEFORESENDINTERFACE_H
#define CHECKBEFORESENDINTERFACE_H

#include <MessageComposer/PluginEditorCheckBeforeSendInterface>
class CheckBeforeSendInterface : public MessageComposer::PluginEditorCheckBeforeSendInterface
{
    Q_OBJECT
public:
    explicit CheckBeforeSendInterface(QObject *parent = nullptr);
    ~CheckBeforeSendInterface() override;

    Q_REQUIRED_RESULT bool exec(const MessageComposer::PluginEditorCheckBeforeSendParams &params) override;

public Q_SLOTS:
    void reloadConfig() override;

private:
    bool mSendPlainText = false;
    bool mCheckMailTransport = false;
    bool mCheckDuplicateEmails = false;
    bool mCheckSendAttachments = false;
};

#endif // CHECKBEFORESENDINTERFACE_H
