/*
    Copyright (C) 2007 Nikolas Zimmermann <zimmermann@kde.org>
    Copyright (C) 2007 Torsten Rahn <rahn@kde.org>

    This file is part of the KDE project

    This library is free software you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    aint with this library see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef MARBLE_DGML_ATTRIBUTEDICTIONARY_H
#define MARBLE_DGML_ATTRIBUTEDICTIONARY_H

namespace Marble
{
namespace dgml
{

    // Lists all known DGML 2.0 attributes
    // http://edu.kde.org/marble/apis/dgml/documentation/dgmltags.html)

    extern const char dgmlAttr_nameSpace20[];

    extern const char dgmlAttr_alpha[];
    extern const char dgmlAttr_attribution[];
    extern const char dgmlAttr_backend[];
    extern const char dgmlAttr_bgcolor[];
    extern const char dgmlAttr_color[];
    extern const char dgmlAttr_colorize[];
    extern const char dgmlAttr_colorMap[];
    extern const char dgmlAttr_checkable[];
    extern const char dgmlAttr_connect[];
    extern const char dgmlAttr_expire[];
    extern const char dgmlAttr_feature[];
    extern const char dgmlAttr_format[];
    extern const char dgmlAttr_height[];
    extern const char dgmlAttr_highlightBrush[];
    extern const char dgmlAttr_highlightPen[];
    extern const char dgmlAttr_host[];
    extern const char dgmlAttr_labelColor[];
    extern const char dgmlAttr_levelZeroColumns[];
    extern const char dgmlAttr_levelZeroRows[];
    extern const char dgmlAttr_maximumConnections[];
    extern const char dgmlAttr_minimumTileLevel[];
    extern const char dgmlAttr_maximumTileLevel[];
    extern const char dgmlAttr_mode[];
    extern const char dgmlAttr_name[];
    extern const char dgmlAttr_password[];
    extern const char dgmlAttr_path[];
    extern const char dgmlAttr_pixmap[];
    extern const char dgmlAttr_port[];
    extern const char dgmlAttr_property[];
    extern const char dgmlAttr_protocol[];
    extern const char dgmlAttr_query[];
    extern const char dgmlAttr_radio[];
    extern const char dgmlAttr_radius[];
    extern const char dgmlAttr_role[];
    extern const char dgmlAttr_short[];
    extern const char dgmlAttr_spacing[];
    extern const char dgmlAttr_style[];
    extern const char dgmlAttr_text[];
    extern const char dgmlAttr_tileLevels[];
    extern const char dgmlAttr_type[];
    extern const char dgmlAttr_usage[];
    extern const char dgmlAttr_user[];
    extern const char dgmlAttr_width[];
}
}

#endif
