/*
   SPDX-FileCopyrightText: 2017-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "externalcomposerplugineditorinterface.h"
#include <KPIMTextEdit/RichTextComposer>
#include <KSharedConfig>
#include <KConfigGroup>

ExternalComposerPluginEditorInterface::ExternalComposerPluginEditorInterface(QObject *parent)
    : MessageComposer::PluginEditorInitInterface(parent)
{
}

ExternalComposerPluginEditorInterface::~ExternalComposerPluginEditorInterface()
{
}

bool ExternalComposerPluginEditorInterface::exec()
{
    if (mEnabled) {
        richTextEditor()->setUseExternalEditor(mEnabled);
        richTextEditor()->setExternalEditorPath(mExternalComposerPath);
    }
    return true;
}

void ExternalComposerPluginEditorInterface::reloadConfig()
{
    KSharedConfig::Ptr config = KSharedConfig::openConfig();
    KConfigGroup group = config->group(QStringLiteral("External Composer"));
    mEnabled = group.readEntry("Enabled", false);
    mExternalComposerPath = group.readEntry("ComposerPath", QString());
}
