/***************************************************************************
                            kstdefaultnames.cpp
                             -------------------
    begin                : July 31, 2004
    copyright            : (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstdatacollection.h"
#include "kstdefaultnames.h"
#include "ksthistogram.h"
#include "kstplugin.h"
#include "kstpsdcurve.h"
#include "kstvcurve.h"

#include <qregexp.h>

QString KST::suggestPlotName() {
  static int last = 0;
  return QString("P%1").arg(++last);
}

QString KST::suggestWinName() {
  static int last = 0;
  return QString("W%1").arg(++last);
}

/* takes a vector or plugin name of the form V2-GYRO1 and returns a unique */
/* curve name of the form C1-GYRO1 */
QString KST::suggestCurveName( const QString& vector_name ) {
  QString name;
  KstVCurveList curves =
    kstObjectSubList<KstDataObject, KstVCurve>(KST::dataObjectList);

  QString field = vector_name;
  field.remove( QRegExp( "^[VP][0-9]{1,2}\\-" ) );
  int n = KST::dataObjectList.count();
  do {
    n++;
    name = QString("C%1-%2").arg(n).arg(field);
  } while ( KST::dataObjectList.findTag(name) != KST::dataObjectList.end() );

  return name;
}

/* takes a vector name of the form V2-GYRO1 and returns a unique */
/* name psd of the form P1-GYRO1 */
QString KST::suggestPSDName( const QString& vector_name ) {
  QString name;
  KstPSDCurveList curves =
    kstObjectSubList<KstDataObject, KstPSDCurve>(KST::dataObjectList);

  QString field = vector_name;
  field.remove( QRegExp( "^V[0-9]{1,2}\\-" ) );
  int n = KST::dataObjectList.count();
  do {
    n++;
    name = QString("P%1-%2").arg(n).arg(field);
  } while ( KST::dataObjectList.findTag(name) != KST::dataObjectList.end() );

  return name;
}

/* takes a vector name of the form V2-GYRO1 and returns a unique */
/* histogram name of the form H1-GYRO1 */
QString KST::suggestHistogramName( const QString& vector_name ) {
  QString name;
  KstHistogramList curves =
    kstObjectSubList<KstDataObject, KstHistogram>(KST::dataObjectList);

  QString field = vector_name;
  field.remove( QRegExp( "^V[0-9]{1,2}\\-" ) );
  int n = KST::dataObjectList.count();
  do {
    n++;
    name = QString("H%1-%2").arg(n).arg(field);
  } while ( KST::dataObjectList.findTag(name) != KST::dataObjectList.end() );

  return name;
}

/* takes a plugin name and an optional vector or curve name of the form V2-GYRO1 */
/* and returns a unique plugin name of the form P1-PNAME-VNAME */
QString KST::suggestPluginName(const QString& pname, const QString& vname) {
  QString name;
  QString field;
  KstPluginList curves =
    kstObjectSubList<KstDataObject, KstPlugin>(KST::dataObjectList);

  if (!vname.isEmpty()) {
    field = vname;
    field.remove( QRegExp( "^[VC][0-9]{1,2}" ) );
  }

  int n = KST::dataObjectList.count();
  do {
    name = QString("P%1-%2%3").arg(n).arg(pname).arg(field);
    n++;
  } while ( KST::dataObjectList.findTag(name) != KST::dataObjectList.end() );

  return name;
}

/* takes a vector or plugin of the form V2-GYRO1 and returns a unique */
/* matrix name of the form M1-GYRO1 */
QString KST::suggestMatrixName(const QString& vector_name) {
  QString name;
  KstVCurveList curves =
    kstObjectSubList<KstDataObject, KstVCurve>(KST::dataObjectList);

  QString field = vector_name;
  field.remove( QRegExp( "^[VP][0-9]{1,2}\\-" ) );
  int n = KST::dataObjectList.count();
  do {
    n++;
    name = QString("M%1-%2").arg(n).arg(field);
  } while ( KST::dataObjectList.findTag(name) != KST::dataObjectList.end() );
  return name;
}

/* takes a matrix name of the form M2-GYRO1 and returns a unique */
/* image name of the form Img1-GYRO1 */
QString KST::suggestImageName(const QString& matrix_name) {
  QString name;
  KstVCurveList curves =
    kstObjectSubList<KstDataObject, KstVCurve>(KST::dataObjectList);

  QString field = matrix_name;
  field.remove( QRegExp( "^[M][0-9]{1,2}\\-" ) );
  int n = KST::dataObjectList.count();
  do {
    n++;
    name = QString("Img%1-%2").arg(n).arg(field);
  } while ( KST::dataObjectList.findTag(name) != KST::dataObjectList.end() );
  return name;
}
// vim: ts=2 sw=2 et
