/***************************************************************************
                                   elog.cpp
                             -------------------
    begin                : Feb 09 2004
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "elog.h"
#include "elogeventthreadsubmit.h"
#include "elogthreadsubmit.h"
#include "elogthreadattrs.h"

#include <kmdimainfrm.h>
#include <kst.h>
#include <kaction.h>
#include <kfiledialog.h>
#include <kgenericfactory.h>
#include <kmessagebox.h>

#include <kstevents.h>

K_EXPORT_COMPONENT_FACTORY(kstextension_elog, KGenericFactory<KstELOG>)

KstELOG::KstELOG(QObject *parent, const char *name, const QStringList& l) : KstExtension(parent, name, l), KXMLGUIClient() {
  new KAction(i18n("&ELOG..."), 0, 0, this, SLOT(doShow()), actionCollection(), "elog_settings_show");
  new KAction(i18n("Add ELOG Entry..."), 0, 0, this, SLOT(doEntry()), actionCollection(), "elog_entry_add");
  setInstance(app()->instance());
  setXMLFile("kstextension_elog.rc", true);
  app()->guiFactory()->addClient(this);

  _elogConfiguration = new ElogConfigurationI( this, app() );
  _elogEventEntry = new ElogEventEntryI( this, app() );
  _elogEntry = new ElogEntryI( this, app() );

  connect( app(), SIGNAL(ELOGConfigure()), this, SLOT(doEventEntry()));
  connect( app(), SIGNAL(ELOGSubmitEntry(const QString&)), this, SLOT(submitEventEntry(const QString&)));

  if( _elogEntry ) {
    _elogEntry->initialize();
  }
  if( _elogEventEntry ) {
    _elogEventEntry->initialize();
  }
  if( _elogConfiguration ) {
    _elogConfiguration->initialize();
  }
}


KstELOG::~KstELOG() {
  if( app() ) {
    if( app()->guiFactory() ) {
      app()->guiFactory()->removeClient(this);
    }
  }
  
  delete _elogConfiguration;
  delete _elogEventEntry;
  delete _elogEntry;
}


void KstELOG::submitEventEntry(const QString& strMessage) {
  ElogEventThreadSubmit* pThread;
  KstELOGCaptureStruct captureStruct;
  QByteArray	byteArrayCapture;
  QByteArray	byteArrayCaptureRaw;
  QDataStream dataStreamCapture( byteArrayCaptureRaw, IO_ReadWrite );
  QCustomEvent eventCapture(KstELOGCaptureEvent);

  if( eventEntry()->includeCapture() ) {
    captureStruct.pBuffer     = &dataStreamCapture;
    captureStruct.iWidth      = configuration()->captureWidth();
    captureStruct.iHeight     = configuration()->captureHeight();
    eventCapture.setData( &captureStruct );

    QApplication::sendEvent( (QObject*)app(), (QEvent*)&eventCapture );
    if( byteArrayCaptureRaw.size() > 0 ) {
      byteArrayCapture.duplicate( byteArrayCaptureRaw.data() + 4, byteArrayCaptureRaw.size() - 4 );
    }
  }

  pThread = new ElogEventThreadSubmit(this,
                                 eventEntry()->includeCapture(),
                                 eventEntry()->includeConfiguration(),
                                 eventEntry()->includeDebugInfo(),
                                 &byteArrayCapture,
                                 strMessage,
                                 configuration()->userName(),
                                 configuration()->userPassword(),
                                 configuration()->writePassword(),
                                 configuration()->name(),
                                 eventEntry()->attributes(),
                                 configuration()->submitAsHTML(),
                                 configuration()->suppressEmail());
  if( pThread ) {
    pThread->start();
  }
}


void KstELOG::submitEntry() {  
  ElogThreadSubmit* pThread;
  KstELOGCaptureStruct captureStruct;
  QByteArray	byteArrayCapture;
  QByteArray	byteArrayCaptureRaw;
  QDataStream dataStreamCapture( byteArrayCaptureRaw, IO_ReadWrite );
  QCustomEvent eventCapture(KstELOGCaptureEvent);

  if( entry()->includeCapture() ) {
    captureStruct.pBuffer     = &dataStreamCapture;
    captureStruct.iWidth      = configuration()->captureWidth();
    captureStruct.iHeight     = configuration()->captureHeight();
    eventCapture.setData( &captureStruct );

    QApplication::sendEvent( (QObject*)app(), (QEvent*)&eventCapture );
    if( byteArrayCaptureRaw.size() > 0 ) {
      byteArrayCapture.duplicate( byteArrayCaptureRaw.data() + 4, byteArrayCaptureRaw.size() - 4 );
    }
  }

  pThread = new ElogThreadSubmit(this,
                                 entry()->includeCapture(),
                                 entry()->includeConfiguration(),
                                 entry()->includeDebugInfo(),
                                 &byteArrayCapture,
                                 entry()->text(),
                                 configuration()->userName(),
                                 configuration()->userPassword(),
                                 configuration()->writePassword(),
                                 configuration()->name(),
                                 entry()->attributes(),
                                 configuration()->submitAsHTML(),
                                 configuration()->suppressEmail());
  if( pThread ) {
    pThread->start();
  }
}


void KstELOG::doEventEntry() {
  if( _elogEventEntry ) {
    _elogEventEntry->show();
    _elogEventEntry->raise();
  }
}


void KstELOG::doEntry() {
  if( _elogEntry ) {
    _elogEntry->show();
    _elogEntry->raise();
  }
}


void KstELOG::doShow() {
  if( _elogConfiguration ) {
    _elogConfiguration->show();
    _elogConfiguration->raise();
  }
}


void KstELOG::load(QDomElement& e) {
  Q_UNUSED(e)
}


void KstELOG::save(QTextStream& ts) {
  Q_UNUSED(ts)
}

#include "elog.moc"
// vim: ts=2 sw=2 et
