/***************************************************************************
                       kstdatamanger_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kstdatamanager_i.h"

#include <assert.h>

#include <qwidget.h>
#include <qstring.h>
#include <klistview.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>

#include "kstdoc.h"
#include "kstplugin.h"
#include "kstrvector.h"
#include "kstdatacollection.h"
#include "kstpsddialog_i.h"
#include "ksteqdialog_i.h"
#include "ksthsdialog_i.h"
#include "kstcurvedialog_i.h"
#include "kstplugindialog_i.h"
#include "kstvectordialog_i.h"

#define RTTI_OBJ_VECTOR      4201
#define RTTI_OBJ_OBJECT      4202
#define RTTI_OBJ_DATA_VECTOR 4203

class KstObjectItem : public QListViewItem {
  public:
    KstObjectItem(QListView *parent, KstRVectorPtr x, KstDataManagerI *dm)
    : QListViewItem(parent), _rtti(RTTI_OBJ_DATA_VECTOR), _name(x->tagName()), _dm(dm) {
      assert(x);
      setText(0, x->tagName());
      setText(1, i18n("Data Vector"));
      setText(2, QString::number(x->getUsage() - 2)); // caller has a ptr
      setText(3, QString::number(x->sampleCount()));
      setText(4, i18n("%3: %4 [%1..%2]").arg(x->reqStartFrame())
                                         .arg(x->reqStartFrame() + x->reqNumFrames())
                                         .arg(x->getFilename())
                                         .arg(x->getField()));
      _removable = x->getUsage() == 2;
    }

    KstObjectItem(QListViewItem *parent, KstVectorPtr x, KstDataManagerI *dm)
    : QListViewItem(parent), _rtti(RTTI_OBJ_VECTOR), _name(x->tagName()), _dm(dm) {
      assert(x);
      setText(0, x->tagName());
      setText(1, i18n("Slave Vector"));
      setText(2, QString::number(x->getUsage() - 2)); // caller also points
      setText(3, QString::number(x->sampleCount()));
      setText(4, i18n("[%1..%2]").arg(x->min()).arg(x->max()));
      _removable = false;
    }

    KstObjectItem(QListView *parent, KstDataObjectPtr x, KstDataManagerI *dm)
    : QListViewItem(parent), _rtti(RTTI_OBJ_OBJECT), _name(x->tagName()), _dm(dm) {
      assert(x.data());
      setText(0, x->tagName());
      setText(1, x->typeString());
      setText(2, QString::number(x->getUsage() - 1)); // our pointer
      setText(3, QString::number(x->sampleCount()));
      setText(4, x->propertyString());
      for (unsigned i = 0; i < x->outputVectors().count(); i++) {
        new KstObjectItem(this, x->outputVectors()[i], _dm);
      }
      _removable = x->getUsage() == 1;
    }

    virtual ~KstObjectItem() {
    }

    virtual int rtti() const { return _rtti; }
    
    const QString& tagName() const { return _name; }
    //KstRVectorPtr rvector() { return *kstObjectSubList<KstVector,KstRVector>(KST::vectorList).findTag(_name); }
    KstDataObjectPtr dataObject() { return *KST::dataObjectList.findTag(_name); }

  protected:
    virtual void activate() {
      _dm->Edit->setEnabled(RTTI_OBJ_VECTOR != _rtti);
      _dm->Delete->setEnabled(_removable);
    }

  private:
    int              _rtti;
    QString          _name;
    KstDataManagerI *_dm;
    bool             _removable;
};



KstDataManagerI::KstDataManagerI(KstDoc *in_doc, QWidget* parent,
                                 const char* name, bool modal, WFlags fl)
: KstDataManager(parent, name, modal, fl) {
    doc = in_doc;

    connect(Edit, SIGNAL(clicked()), this, SLOT(edit_I()));
    connect(Delete, SIGNAL(clicked()), this, SLOT(delete_I()));
    connect(Purge, SIGNAL(clicked()), doc, SLOT(purge()));
    connect(DataView, SIGNAL(doubleClicked(QListViewItem *)),
            this, SLOT(edit_I()));

    connect(NewCurve, SIGNAL(clicked()),
            KstCurveDialogI::globalInstance(), SLOT(show_New()));
    connect(NewHs, SIGNAL(clicked()),
            KstHsDialogI::globalInstance(), SLOT(show_New()));
    connect(NewEq, SIGNAL(clicked()),
            KstEqDialogI::globalInstance(), SLOT(show_New()));
    connect(NewPlugin, SIGNAL(clicked()),
            KstPluginDialogI::globalInstance(), SLOT(show_New()));
    connect(NewPSD, SIGNAL(clicked()),
            KstPsdDialogI::globalInstance(), SLOT(show_New()));
    connect(NewVector, SIGNAL(clicked()),
            KstVectorDialogI::globalInstance(), SLOT(show_New()));
}

KstDataManagerI::~KstDataManagerI() {
}

void KstDataManagerI::show_I() {
  update();
  show();
  raise();
}

void KstDataManagerI::update() {
  DataView->clear();

  for (KstDataObjectList::iterator it = KST::dataObjectList.begin();
                                    it != KST::dataObjectList.end();
                                                               ++it) {
    new KstObjectItem(DataView, *it, this);
  }

  KstRVectorList rvl = kstObjectSubList<KstVector,KstRVector>(KST::vectorList);
  for (KstRVectorList::iterator it = rvl.begin(); it != rvl.end(); ++it) {
    new KstObjectItem(DataView, *it, this);
  }

  Edit->setEnabled(false);
  Delete->setEnabled(false);
}

void KstDataManagerI::edit_I() {
  QListViewItem *qi;

  if (DataView->selectedItems().count() > 0) {
    qi = DataView->selectedItems().at(0);
  } else {
    KMessageBox::sorry(this, i18n("A data item must be selected to edit."));
    return;
  }

  if (qi->rtti() == RTTI_OBJ_DATA_VECTOR) {
    emit editDataVector(qi->text(0));
  }

  if (qi->rtti() == RTTI_OBJ_OBJECT) {
    static_cast<KstObjectItem*>(qi)->dataObject()->showDialog();
  }
}

void KstDataManagerI::delete_I() {
  QListViewItem *qi = DataView->selectedItems().at(0);
  KstObjectItem *koi = static_cast<KstObjectItem*>(qi);

  if (qi->rtti() == RTTI_OBJ_OBJECT) {
    doc->removeDataObject(koi->tagName());
  } else if (qi->rtti() == RTTI_OBJ_DATA_VECTOR) {
    KST::vectorList.removeTag(koi->tagName());
    doc->setModified();
    doc->update();
    doc->updateDialogs();
  }
}

#include "kstdatamanager_i.moc"
// vim: ts=2 sw=2 et
