/***************************************************************************
                          kplitem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Wed Aug 25 1999
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qtextstream.h>
#include <ksimpleconfig.h>
#include "kplitem.h"
#include "kplgraph.h"

KplItem::KplItem() : active(true), x0(0.0), y0(0.0), relsiz(1.0)
{
}

KplItem::KplItem(KSimpleConfig* plo)
{
  active = plo->readBoolEntry("active", true);
  x0 = plo->readDoubleNumEntry("x");
  y0 = plo->readDoubleNumEntry("y");
  relsiz = plo->readDoubleNumEntry("relsiz", 1.0);
}

KplItem::KplItem(bool act, double x, double y, double relSize) :
 active(act), x0(x), y0(y), relsiz(relSize)
{
}

KplItem::~KplItem()
{
}

#ifndef KPL_CLASSES_ONLY
void KplItem::writePlo(KSimpleConfig* plo, const KURL&, bool, KplDoc*) const
{
  if (!active)
    plo->writeEntry("active", active);
  plo->writeEntry("x", x0);
  plo->writeEntry("y", y0);
  plo->writeEntry("relsiz", relsiz);
}

void KplItem::exportTable(QTextStream&, KplDoc*) const
{
}
#endif

void KplItem::normalize(double, double)
{
}

void KplItem::expoItem(int*, int*, double*, double*) const
{
}

void KplItem::minMax(double*, double*, double*, double*) const
{
}

void KplItem::setPar(int, double, bool)
{
}

ScaledItem::ScaledItem() : fillStyle(0), symb(0), color(0), fx(1.0), fy(1.0)
{
}

ScaledItem::ScaledItem(KplNamespace::AutoStruct* aut) : fillStyle(0),
 symb(aut->autoSymb), color(aut->colData), fx(1.0), fy(1.0)
{
}

ScaledItem::ScaledItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut) :
 KplItem(plo)
{
  readPlo(plo, aut);
}

ScaledItem::ScaledItem(bool act, int fill, int sym, const QString& col,
                       double fxa, double fya, double relSize) :
 KplItem(act, 0.0, 0.0, relSize), fillStyle(fill), symb(sym), fx(fxa), fy(fya)
{
  color = KplGraph::rgbQt(col);
}

ScaledItem::~ScaledItem()
{
}

void ScaledItem::readPlo(KSimpleConfig* plo, KplNamespace::AutoStruct* aut)
{
  fillStyle = plo->readNumEntry("fillstyle");
  symb = plo->readNumEntry("symb", aut->autoSymb);
  QString s = plo->readEntry("color", "");
  color = s.isEmpty() ? aut->colData : KplGraph::rgbQt(s);
  fx = plo->readDoubleNumEntry("fx", 1.0);
  fy = plo->readDoubleNumEntry("fy", 1.0);
}

#ifndef KPL_CLASSES_ONLY
void ScaledItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                          KplDoc* m) const
{
  KplItem::writePlo(plo, url, abs, m);
  plo->writeEntry("fillstyle", fillStyle);
  plo->writeEntry("symb", symb);
  plo->writeEntry("color", QString::number(KplGraph::rgbQt1(color), 16));
  plo->writeEntry("fx", fx);
  plo->writeEntry("fy", fy);
}
#endif

void ScaledItem::normalize(double fx0, double fy0)
{
  fx = fx0;
  fy = fy0;
}

void ScaledItem::setProperties(KplGraph* g) const
{
  g->setColData(color);
  g->setSymbol(symb);
  g->fxn = fx;
  g->fyn = fy;
}

DecoItem::DecoItem() : color(0)
{
}

DecoItem::DecoItem(KplNamespace::AutoStruct* aut) :
 color(aut->colFrame)
{
}

DecoItem::DecoItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut) :
 KplItem(plo)
{
  QString s = plo->readEntry("colsymb", "");
  color = s.isEmpty() ? aut->colFrame : KplGraph::rgbQt(s);
}

DecoItem::DecoItem(bool act, const QString& col, double x, double y,
                   double relSize) : KplItem(act, x, y, relSize)
{
  color = KplGraph::rgbQt(col);
}

DecoItem::~DecoItem()
{
}

#ifndef KPL_CLASSES_ONLY
void DecoItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const
{
  KplItem::writePlo(plo, url, abs, m);
  plo->writeEntry("colsymb", QString::number(KplGraph::rgbQt1(color), 16));
}
#endif
