/***************************************************************************
                          decodlg.h  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DECODLG_H
#define DECODLG_H

#include <kdialogbase.h>

class QVBoxLayout;
class QGridLayout;
class QLabel;
class KplSpinBox;
class KColorButton;
class DecoItem;
class KplDoc;
class KplDoubleEdit;

/**
  * Decoration settings dialog class. Provides a base dialog for the settings
  * dialogs for text, line, and arrow decoration items.
  * @author Werner Stille
  */
class DecoDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param caption window caption.
   * @param anchor help anchor string.
   * @param model pointer to KplDoc model object.
   * @param it pointer to decoration item.
   * @param nrows number of rows of grid layout.
   */
  DecoDlg(QWidget* parent, QString caption, QString anchor, KplDoc* model,
          DecoItem* it, int nrows);
  /** Destructor. */
  ~DecoDlg();

protected:
  /**
   * Creates entry widgets.
   * @param row row index for position widgets.
   */
  void initEntries(int row);
  /**
   * Copies settings to deco item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  DecoItem* it;
  KplDoubleEdit *ex0, *ey0;
  KplSpinBox* eRelSize;
  KColorButton* col;
  QVBoxLayout* vbox;
  QGridLayout* grid;
  QLabel* lSize;
};

#endif
