/***************************************************************************
                          linedlg.cpp  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "lineitem.h"
#include "symboldlg.h"
#include "linedlg.h"
#include "arrowdlg.h"

LineDlg::LineDlg(QWidget* _parent, KplDoc* model, LineItem* ld0) :
 DecoDlg(_parent, i18n("Line"), "SEC-LINE", model, ld0, 4), ld(ld0)
{
  QFrame* frame = plainPage();
  ArrowDlg::initPolarEntries(frame, ld, grid, &eDir, &eLen);
  initEntries(1);
  lSize->setText(i18n("Width"));
  grid->addWidget(new QLabel(i18n("Type"), frame), 3, 0);
  grid->addWidget(symb = new KplSpinBox(1, 9, 1, frame), 3, 1);
  symb->setValue(ld->symb);
  grid->addWidget(new SymbolButton(frame, symb, false, true), 3, 2);
}

LineDlg::~LineDlg()
{
}

void LineDlg::getValues(bool ok)
{
  ld->symb = symb->interpretedValue();
  ld->dir = eDir->value();
  ld->len = eLen->value();
  DecoDlg::getValues(ok);
}

void LineDlg::slotOk()
{
  getValues(true);
}

void LineDlg::slotApply()
{
  getValues(false);
}
