/***************************************************************************
                          kplwidget.cpp  -  description
                             -------------------
    begin                : Mon Jul 16 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qptrlist.h>
#include <kprinter.h>
#include "kplitem.h"
#include "kplwidget.h"

KplWidget::KplWidget(QWidget* parent) : QScrollView(parent)
{
  QScrollView::viewport()->setBackgroundMode(PaletteBase);
}

KplWidget::KplWidget(QWidget* parent, QPtrList<KplItem>* items, int w, int h,
                     double zoom, double xf, double yf) : QScrollView(parent)
{
  QScrollView::viewport()->setBackgroundMode(PaletteBase);
  paintWidget(items, w, h, zoom, xf, yf);
}

KplWidget::~KplWidget()
{
}

void KplWidget::paintWidget(QPtrList<KplItem>* items, int w, int h,
                            double zoom, double xf, double yf, bool paint)
{
  if ((w != contentsWidth()) || (h != contentsHeight()))
    resizeContents(w, h);
  pm.resize(w, h);
  plInit(&pm);
  factor = zoom;
  format(xf, yf);
  if (paint)
    drawItems(this, items);
  end();
}

void KplWidget::drawItems(KplGraph* g, QPtrList<KplItem>* items)
{
  for (KplItem* item = items->first(); item; item = items->next())
    item->draw(g);
}

void KplWidget::print(KPrinter* printer, QPtrList<KplItem>* items)
{
  KGraph g;
  QSize sz = printer->margins();
  g.plInit(printer, sz.width(), sz.height());
  drawItems(&g, items);
  g.end();
}

QSize KplWidget::sizeHint() const
{
  return QSize(contentsWidth() + 4, contentsHeight() + 4);
}

void KplWidget::drawContents(QPainter*, int clipx, int clipy, int clipw,
                             int cliph)
{
  QRect r(clipx, clipy, QMIN(clipw, pm.width() - clipx),
          QMIN(cliph, pm.height() - clipy));
  if (r.isValid())
    bitBlt(QScrollView::viewport(),
           contentsToViewport(QPoint(clipx, clipy)), &pm, r, CopyROP);
}
