/***************************************************************************
                          arcitem.h  -  description
                             -------------------
    begin                : Sam Aug 17 2002
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARCITEM_H
#define ARCITEM_H

#include <kplitem.h>

/**
  * Arc item class. Class for arc decoration items.
  * @author Werner Stille
  */
class ArcItem : public DecoItem
{
public: 
  /** Constructor */
  ArcItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  ArcItem(KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  ArcItem(KSimpleConfig* plo, KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param color color for arc.
    * @param x x position in cm.
    * @param y y position in cm.
    * @param w width in cm.
    * @param h height in cm.
    * @param a start angle in degree.
    * @param alen length in degree.
    * @param relSize relative line width.
    * @param ang rotation angle in degree.
    */
  ArcItem(bool active, const QString& color, double x, double y, double w,
          double h, double a, double alen, double relSize, double ang = 0.0);
  /** Destructor */
  ~ArcItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
#ifndef KPL_CLASSES_ONLY
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(QListViewItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
#endif
  virtual KplItem* copy() const;

protected:
  double width, height, dir, a, alen;

  friend class ArcDlg;
};

#endif
