/***************************************************************************
                          autofitdlg.cpp  -  description
                             -------------------
    begin                : Sat Jun 5 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qgroupbox.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qfileinfo.h>
#include <qlayout.h>
#include <qtimer.h>
#include <kapp.h>
#include <klocale.h>
#include <kcolorbtn.h>
#include <kmessagebox.h>
#include "autofitdlg.h"
#include "kpldoc.h"
#include "utils.h"
#include "fitdlg.h"
#include "symboldlg.h"
#include "sourcewidget.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"

EditFitParameterDlg::EditFitParameterDlg(QWidget* parent, KplDoc* m,
                                         double* p0, bool* bFit0,
                                         const QString& file,
                                         const QString& func) :
 QDialog(parent, 0, true), bFit(bFit0), p(p0)
{
  setCaption(i18n("Fit parameters"));
  QHBoxLayout* hbox = 0;
  QVBoxLayout* vbox;
  if (m->aut.showSource) {
    hbox = new QHBoxLayout(this, 11, 6);
    vbox = new QVBoxLayout(hbox);
  } else
    vbox = new QVBoxLayout(this, 11, 6);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, this);
  QGridLayout* grid = new QGridLayout(g->layout(), QMIN(KPL_NPMAX, 10),
                                      2 + 3 * ((KPL_NPMAX - 1) / 10), 6);
  vbox->addWidget(g);
  QString s;
  for (int i = 0; i < KPL_NPMAX; i++) {
    int ix = 3 * (i / 10);
    int iy = i % 10;
    grid->addWidget(enFit[i] = new QCheckBox(s.sprintf("p%i", i), g), iy, ix);
    enFit[i]->setChecked(bFit[i]);
    grid->addWidget(par[i] = new QLineEdit(QString::number(p[i], m->aut.format,
      m->aut.prec), g), iy, ix + 1);
    par[i]->setMaximumWidth(80);
  }
  for (int i = 0; i < ((KPL_NPMAX - 1) / 10); i++)
    grid->addItem(new QSpacerItem(20, 10), 0, 3 * i + 2);
  QHBoxLayout* hbox2 = new QHBoxLayout(vbox);
  QPushButton *b = new QPushButton(i18n("OK"), this);
  hbox2->addWidget(b);
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox2->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
  if (m->aut.showSource) {
    QFileInfo fi(file);
    int pp = func.find("__");
    s = fi.dirPath(true) + "/" + fi.baseName() + ((pp != -1) ? ".cpp" : ".c");
    QFile f(s);
    if (f.open(IO_ReadOnly)) {
      SourceWidget *sw = new SourceWidget(this, &f);
      hbox->addWidget(sw, 1);
      sw->setMinimumWidth(400);
      if (pp != -1) {
        s = func;
        sw->highlight(s.left(pp));
      } else
        sw->highlight(func);
      QTimer::singleShot(0, sw, SLOT(slotHighlight()));
    }
  }
}

EditFitParameterDlg::~EditFitParameterDlg()
{
}

void EditFitParameterDlg::slotOK()
{
  QString s;
  double pt[KPL_NPMAX];
  bool valid = true;
  for (int i = 0; i < KPL_NPMAX; i++) {
    s = par[i]->text();
    pt[i] = s.toDouble(&valid);
    if (!valid) {
      KMessageBox::sorry(this, s.sprintf(i18n("invalid parameter %i"), i));
      return;
    }
  }
  memcpy(p, pt, KPL_NPMAX * sizeof(double));
  for (int i = 0; i < KPL_NPMAX; i++)
    bFit[i] = enFit[i]->isChecked();
  accept();
}

AutoFitDlg::AutoFitDlg(QWidget* parent, KplDoc* m0) :
 QDialog(parent, 0, true), m(m0)
{
  aut = new Kpl::AutoStruct(m->aut);
  resize(370, 410);
  setCaption(i18n("Autofit settings"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "y(x)", this);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, 6);
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileName = new QLineEdit(aut->fitPath, g));
  QPushButton *b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(func = new QLineEdit(aut->fitName, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFunc()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameter()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, this));
  QVBoxLayout* vbox2 = new QVBoxLayout(g->layout(), 6);
  vbox2->addLayout(hbox = new QHBoxLayout());
  vbox2->addWidget(nonLin = new QCheckBox(i18n("Nonlinear fit"), g));
  nonLin->setChecked(aut->fitNonLin);
  grid = new QGridLayout(vbox2, 3, 5, 12);
  grid->addWidget(errCol = new QCheckBox(i18n("Error column"), g), 0, 0);
  errCol->setChecked(aut->err.fitErrCol);
  connect(errCol, SIGNAL(toggled(bool)), SLOT(disableErrMod(bool)));
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 1);
  grid->addWidget(errMod = new QPushButton(i18n("Model"), g), 0, 4);
  connect(errMod, SIGNAL(clicked()), SLOT(slotErrMod()));
  disableErrMod(aut->err.fitErrCol);
  grid->addWidget(new QLabel(i18n("Maximum iterations"), g), 1, 0);
  grid->addWidget(sItmax = new KplSpinBox(1, 200, 1, g), 1, 1);
  sItmax->setValue(aut->fitMaxIt);
  grid->addWidget(new QLabel(i18n("Tolerance"), g), 1, 3);
  grid->addWidget(eTol = new KplDoubleEdit(aut->fitTol, 0.0, 1.0, g, "%.6lg"),
                  1, 4);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 0);
  hbox->addWidget(new QLabel(i18n("Symbol"), g));
  hbox->addWidget(symb = new KplSpinBox(-17, 9, 1, g));
  symb->setValue(aut->fitSymb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  bSymb->setFixedWidth(50);
  grid->addWidget(bSymb, 2, 1);
  grid->addWidget(new QLabel(i18n("Color"), g), 2, 3);
  grid->addWidget(colData = new KColorButton(aut->fitColor, g), 2, 4);
  vbox2->addWidget(showDlg = new QCheckBox(i18n("Show dialog"), g));
  showDlg->setChecked(aut->fitShowDlg);
  vbox2->addWidget(saveRes = new QCheckBox(i18n("Save parameters"), g));
  saveRes->setChecked(aut->fitSavePar);
  vbox2->addWidget(follow = new QCheckBox(i18n("Follow parameters"), g));
  follow->setChecked(aut->fitFollow);
  vbox->addLayout(hbox = new QHBoxLayout());
  hbox->addWidget(b = new QPushButton(i18n("Help"), this));
  connect(b, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(b = new QPushButton(i18n("OK"), this));
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
  connect(nonLin, SIGNAL(toggled(bool)), SLOT(enableNonLin(bool)));
  enableNonLin(aut->fitNonLin);
}

AutoFitDlg::~AutoFitDlg()
{
  delete aut;
}

void AutoFitDlg::slotFile()
{
  Utils::getFile(fileName, m);
}

void AutoFitDlg::slotFunc()
{
  QFileInfo fi(fileName->text());
  QString path = fi.dirPath(true);
  QFile f(path + "/" + fi.baseName() + ".def");
  if (f.open(IO_ReadOnly)) {
    ChooseFuncDlg dlg(this, &f, func);
    dlg.exec();
  } else
    KMessageBox::error(this, i18n("while trying to open "
                                  "module definition file"));
}

void AutoFitDlg::slotGetParameter()
{
  Utils::getPar(this, aut->pFit, m);
}

void AutoFitDlg::slotEditParameter()
{
  EditFitParameterDlg dlg(this, m, aut->pFit, aut->fitPar, fileName->text(),
                          func->text());
  dlg.exec();
}

void AutoFitDlg::slotSaveParameter()
{
  m->connectIOfinished();
  Utils::saveFunPar(this, aut->pFit, m);
}

void AutoFitDlg::slotErrMod()
{
  ErrModDlg dlg(this, m, &aut->err);
  dlg.exec();
}

void AutoFitDlg::disableErrMod(bool off)
{
  errMod->setEnabled(!off);
}

void AutoFitDlg::enableNonLin(bool on)
{
  eTol->setEnabled(on);
  sItmax->setEnabled(on);
}

void AutoFitDlg::slotOK()
{
  aut->fitNonLin = nonLin->isChecked();
  if (aut->fitNonLin) {
    aut->fitTol = eTol->value();
    aut->fitMaxIt = sItmax->interpretedValue();
  }
  aut->fitPath = fileName->text();
  aut->fitName = func->text();
  aut->err.fitErrCol = errCol->isChecked();
  aut->fitShowDlg = showDlg->isChecked();
  aut->fitSavePar = saveRes->isChecked();
  aut->fitFollow = follow->isChecked();
  aut->fitColor = colData->color().rgb();
  aut->fitSymb = symb->interpretedValue();
  m->aut = *aut;
  accept();
}

void AutoFitDlg::slotHelp()
{
  kapp->invokeHelp("SEC-AUTOFIT");
}
