/*********************************************************************************
                          kbeartransferviewitem.h  -  description
                             -------------------
    Begin					: Wed Jul 26 2000
    Copyright				: (C) 2000 by Bjrn Sahlstrm
    Email						: bjorn.sahlstrom@mail.bip.net
 ********************************************************************************/

/*********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 ********************************************************************************/

#ifndef KBEARTRANSFERVIEWITEM_H
#define KBEARTRANSFERVIEWITEM_H
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/job.h>
#include <kio/progressbase.h>
#include <kio/jobclasses.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// application specific include files
#include "kbeartreeview.h"
#include "kbeartransferview.h"

class KBearTransferView;

/**
	*This class represents a transferjob, it connects the @ref KIO::Job signals with apropriate slots.
	* On the graphic side it shows an item in the TransferView
	*@short This class represents a transferjob
	*@see KBearTransferView
  *@author Bjrn Sahlstrm
*/
class KBearTransferViewItem : public ProgressBase {
   Q_OBJECT
public:
	/**  */
	KBearTransferViewItem( KIO::Job* job, KBearTransferView* v,
								const QString& host );
	/**  */
	virtual ~KBearTransferViewItem();
	/**
	* @returns A pointer to the @ref KIO::Job associated to this item
	*/
	KIO::Job* myJob() { return p_myJob; }
	/**
	* @returns A pointer to the graphical @ref KBearTreeViewItem associated with this item
	*/
	KBearTreeViewItem* myTreeViewItem() { return p_myTreeViewItem; }
signals: // Signals
  /**
  * Emitted when the transfer job is finished and the item wants to be removed
  * from the @ref KBearTransferView
  */
  void removeMe( KBearTransferViewItem* );

public slots: // Public slots
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotClean();
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotTotalSize( KIO::Job*, unsigned long );
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotTotalFiles( KIO::Job*, unsigned long );
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotTotalDirs( KIO::Job*, unsigned long );
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotProcessedSize( KIO::Job*, unsigned long );
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotSpeed( KIO::Job*, unsigned long );
	/** Reimlemented from @ref KIO::Progressbase */
	virtual void slotPercent( KIO::Job*, unsigned long );
	/**  */
	virtual void slotCopying( KIO::Job*, const KURL&, const KURL& );
	/**  */
	virtual void slotMoving( KIO::Job*, const KURL&, const KURL& );
	/**  */
	virtual void slotCreatingDir( KIO::Job*, const KURL& ) ;

protected slots: // Protected slots
	/**  */
	void slotShowMenu( KBearTreeViewItem* i );
	/**  */
	void slotStop();

private: // Private attributes
	KBearTreeViewItem* p_myTreeViewItem;
	KBearTransferView* p_myTransferView;
	KIO::Job* p_myJob;
	QPixmap myPix;
	unsigned long totalSize;
	unsigned long processedSize;
};

#endif
