/***************************************************************************
                          kbearfiledetailview.cpp  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearfiledetailview.h"
#include "kbearftpview.h"
#include "kbeardiroperator.h"

static const int autoOpenTime = 750;
//-----------------------------------------------
KBearFileDetailView::KBearFileDetailView( QWidget* p, const char *n )
 :	KFileDetailView( p, n ), dropItem(0), myAutoOpenTimer(this)
{
	setDragEnabled( true );
	setAutoUpdate( true );
	setDropVisualizer( true );
	setAcceptDrops( true );
	viewport()->setAcceptDrops( true );
	connect( &myAutoOpenTimer, SIGNAL( timeout() ),	this, SLOT( slotOpenFolder() ) );
}
//-----------------------------------------------
KBearFileDetailView::~KBearFileDetailView(){
}
//-----------------------------------------------
void KBearFileDetailView::slotOpenFolder(){
	myAutoOpenTimer.stop();
	if( !dropItem )
		return;
	const KFileViewItemList* fileList = KFileView::items();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for( ; it.current() ;++it ){
		if( (*it)->name() == dropItem->text(0) && (*it)->isFile())
			return;
	}
	KURL url = myOp->url();
	url.cd( dropItem->text(0) );
	myOp->setURL( url.path( 1 ), true );
}
//-----------------------------------------------
void KBearFileDetailView::contentsDragEnterEvent( QDragEnterEvent *e ) {
	setSelectionMode( KFile::Single );
	if ( QUriDrag::canDecode( e ) ) {
		e->accept();
		QListViewItem *i = itemAt( contentsToViewport( e->pos() ) );
		if ( i ) {
			dropItem = i;
			myAutoOpenTimer.start( autoOpenTime );
		}
	}
}
//-----------------------------------------------
void KBearFileDetailView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	if ( QUriDrag::canDecode( e ) ) {
		e->accept();
		QListViewItem *i = itemAt( contentsToViewport(  e->pos() ) );
		if ( i ) {
			if ( i != dropItem ) {
				myAutoOpenTimer.stop();
				dropItem = i;
				myAutoOpenTimer.start( autoOpenTime );
			}
		}
		else
			myAutoOpenTimer.stop();
	}
}
//-----------------------------------------------
void KBearFileDetailView::contentsDragLeaveEvent( QDragLeaveEvent* ) {
	myAutoOpenTimer.stop();
	dropItem = 0;
	setSelectionMode( KFile::Extended );
}
//-----------------------------------------------
void KBearFileDetailView::contentsDropEvent( QDropEvent* e ) {
	setSelectionMode( KFile::Extended );
	myAutoOpenTimer.stop();
	dropItem = 0;
	if ( QUriDrag:: canDecode( e ) ) {
		e->accept();
		QListViewItem *afterme;
		QPoint p (contentsToViewport( e->pos() ));

		// Get the position to put it in
		QListViewItem *atpos = itemAt( p );

		if ( ! atpos ) // if no item
			afterme = lastItem();
		else { // get the closest one
			// That is, the space between two listviewitems
			// Since this aims to be user-friendly :)
			int y = mapFromGlobal(p).y() - mapFromGlobal(itemRect(atpos).topLeft()).y();
			afterme = y < (atpos->height()/2) ? atpos->itemAbove() : atpos;
		}
		myOp->myFtpView()->dropped( e );
	}
}
//-----------------------------------------------
void KBearFileDetailView::startDrag(){
	// create a list of the URL:s that we want to drag
	QStringList lst;
	const KFileViewItemList* fileList = KFileView::selectedItems();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for ( ; it.current(); ++it ){
		lst << (*it)->url().prettyURL();
	}
	myDragObject = new QUriDrag( this );
	((QUriDrag*)myDragObject)->setUnicodeUris( lst );
	myDragObject->setPixmap( *(currentItem()->pixmap(0)) );
	myDragObject->dragCopy();   // start the drag
}
//-----------------------------------------------
void KBearFileDetailView::setOperator(QObject *ops) {
	KFileView::setOperator( ops );
	myOp = (KBearDirOperator*)ops;
}
//-----------------------------------------------
