/***************************************************************************
                          kbeardirview.cpp  -  description
                             -------------------
    begin                : Sun Jun 4 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbeardirview.h"
#include "kbearftpview.h"
#include <kdebug.h>
static const int autoOpenTime = 750;
//-----------------------------------------------
KBearDirView::KBearDirView( KBearFtpView* view, QWidget *parent, const char *name )
	 : KListView(parent,name), dropItem(0),	myAutoOpenTimer(this), p_myFtpView( view )
{
	setCurrentItem( 0 );
	addColumn( i18n("Name") );
	setItemsMovable( true );
	setRootIsDecorated( true );
	setSelectionModeExt( KListView::Single );
	setDragEnabled( true );
	setDropVisualizer( true );
	setAcceptDrops( true );
	viewport()->setAcceptDrops( true );
	connect( this , SIGNAL( executed( QListViewItem* ) ), this, SLOT( slotFolderSelected( QListViewItem* ) ) );
	connect( &myAutoOpenTimer, SIGNAL( timeout() ),	this, SLOT( slotOpenFolder() ) );
}
//-----------------------------------------------
KBearDirView::~KBearDirView(){
}
//-----------------------------------------------
void KBearDirView::slotNewDirEntry( KFileViewItem* item ) {
	if( item->name() == ".." )
		return;
	if ( ! item->isFile() ) {
		QListViewItem* i;
		i = currentItem()->firstChild();
		while( i ) {
			if( ((KBearDirViewItem*)i)->url().path(1) == item->url().path(1)){
				return;
			}
			else
				i = i->itemBelow();
		}
		(void)new KBearDirViewItem( (KBearDirViewItem*)currentItem(), item, item->name());
	}
}
//-----------------------------------------------
void KBearDirView::slotFolderSelected( QListViewItem* item ){
	if( item){
		if( item->isOpen() ){
			QListViewItem* i = item->parent();
			if( ! i )
				i = item;
			((KBearDirViewItem*)item)->setOpenExt( false ) ;
			setCurrentItem( i );
			sendFolderStatusChanged( item );
		}
		else {
			setCurrentItem( item );
			((KBearDirViewItem*)item)->setOpenExt( true ) ;
			sendFolderStatusChanged( item );
		}
	}
}
//-----------------------------------------------
void KBearDirView::setDir( const QString &path ) {
	if( ((KBearDirViewItem*)currentItem())->url().path(1) == path ){  // if current item is same as path
		((KBearDirViewItem*)currentItem())->setOpenExt( true );      // make sure it's opened and return
		return;
	}
	url.setPath( path );
	//url = url.url( 1 );  ???????????????????
	if( url.path( 1 ) == "/" )
		setCurrentItem( firstChild() );

	QStringList splittedPath( QStringList::split( "/", path ) ); // split the path
	QStringList splittedRootPath( QStringList::split( "/", firstChild()->text( 0 ) ) ); // split current root objects path
	QString tmp;
	const int sizeOfPathTree = splittedPath.count(); //  save size of path tree
	const int sizeOfRootPathTree = splittedRootPath.count(); //  save size of root path tree
	if( sizeOfPathTree >= sizeOfRootPathTree ) {   // if selected path is below root path
		QListViewItemIterator it( this );
		QListViewItem *item = 0L;
		for ( ; it.current(); ++it ) {
			if ( ((KBearDirViewItem*)it.current())->url().path(1) == path ) { // look if the path exists in the tree
				item = it.current();                                              // if it exists set item to path
				break;
			}
		}
		if( item ) { // if item is set we have already been here
			((KBearDirViewItem*)item)->setOpenExt( true ); // open the path
			setCurrentItem( item );              // and set it as current item
			setSelected( item, true );
			while( item->parent() ) {           // then make sure that all items above is opened
				item = item->parent();			
				((KBearDirViewItem*)item)->setOpenExt( true );
			}
		}
		else { 										// if the path haven't been visited already
			clear();                          // then we have to rebuild the tree
			rebuildNewTree();
		}
	}
	else if( sizeOfPathTree < sizeOfRootPathTree - 1 ) { // if more than two step backwards from root
		clear();                                                             // then we have to rebuild the tree
		rebuildNewTree();
	}
	else { // if one step up from root path
		QListViewItem *item = firstChild();
		KFileViewItem* i = new KFileViewItem( -1,-1, url, false );
		KBearDirViewItem* root = new KBearDirViewItem( this, i, url.path() );
		item->setText( 0, splittedRootPath.last() );
		moveItem( item, root, root );
		root->setOpenExt( true );
		setCurrentItem( root );
		setSelected ( root, true );
	}	
}
//-----------------------------------------------
void KBearDirView::rebuildNewTree(){
	KFileViewItem* i = new KFileViewItem( -1,-1, url, false );
	KBearDirViewItem* root = new KBearDirViewItem( this, i, url.path( 1 ) );
	root->setOpenExt( true );
	setCurrentItem( root );
	setSelected ( root, true );
}
//-----------------------------------------------
void KBearDirView::sendFolderStatusChanged( QListViewItem* item ){
	if( item )
		emit folderStatusChanged( item );
	else
		emit folderStatusChanged( firstChild() );
}
//-----------------------------------------------
void KBearDirView::slotSetFolderLocked( QString path ){
	QListViewItem *item = firstChild();
	while ( item ) {
		if ( ((KBearDirViewItem*)item)->url().path(1) == path ) {
			QPixmap* pix = new QPixmap( KGlobal::iconLoader()
														->loadIcon("folder_locked", KIcon::Small ));
			((KBearDirViewItem*)item)->setPixmap( pix );
			((KBearDirViewItem*)item)->isLocked = true;
			((KBearDirViewItem*)item)->setExpandable( false );
			return;
		}
		item = item->itemBelow();
	}
}
//-----------------------------------------------
/** sets the URL for the view */
void KBearDirView::setURL( const KURL& u ){
	url = u;
}
//-----------------------------------------------
void KBearDirView::slotOpenFolder(){
	myAutoOpenTimer.stop(); // stop timer
	if( dropItem )  // if we have a dropItem
		dropItem->setOpen( true ); // open it
}
//-----------------------------------------------
void KBearDirView::startDrag(){
	myDragObject =  new QUriDrag( viewport() );
	// create a list of the URL:s which should be dragged
	QListViewItem *item = firstChild();
	QStringList dragItemList;
	while ( item ) {
		if ( item->isSelected() ) {// is this item selected ?
			KBearDirViewItem* i = (KBearDirViewItem*)item;
			KFileViewItem* selectedItem = (KFileViewItem*)i;
			dragItemList << selectedItem->urlString();  // add item to drag list
		}
		item = item->itemBelow();
	}
	((QUriDrag*)myDragObject)->setUnicodeUris( dragItemList );
	myDragObject->setPixmap( KGlobal::iconLoader()->loadIcon("folder",KIcon::Small));
	myDragObject->dragCopy();   // start the drag
}
//-----------------------------------------------
void KBearDirView::contentsDragEnterEvent( QDragEnterEvent *e ) {
//	setSelectionModeExt( KListView::Single );
	if ( QUriDrag::canDecode( e ) ) {
		e->accept( true );
		QListViewItem *i = itemAt( contentsToViewport( e->pos() ) );
		if ( i ) {
			dropItem = i; // set dropItem
			myAutoOpenTimer.start( autoOpenTime );  // start timer
		}
	}
}
//-----------------------------------------------
void KBearDirView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	if ( QUriDrag::canDecode( e ) ) {
		e->accept( true );
		QListViewItem *i = itemAt( contentsToViewport(  e->pos() ) );
		if ( i ) {
			if ( i != dropItem ) { // if this item isn't the same as dropItem
				myAutoOpenTimer.stop(); // stop timer
				dropItem = i; // set dropItem
				myAutoOpenTimer.start( autoOpenTime ); // start timer
			}
		}
		else
			myAutoOpenTimer.stop(); // stop timer
	}
}
//-----------------------------------------------
void KBearDirView::contentsDragLeaveEvent( QDragLeaveEvent* ) {
	myAutoOpenTimer.stop();  // stop timer
	dropItem = 0;  // reset dropItem
//	setSelectionModeExt( KListView::Extended); // set selection mode back to extended
}
//-----------------------------------------------
void KBearDirView::contentsDropEvent( QDropEvent* e ) {
//	setSelectionModeExt( KListView::Extended );  // set selection mode back to extended
	myAutoOpenTimer.stop();  // stop timer
	dropItem = 0; // reset dropItem
	if ( QUriDrag:: canDecode( e ) ) {
		e->accept();
		QListViewItem *afterme;
		QPoint p (contentsToViewport( e->pos() ));

		// Get the position to put it in
		QListViewItem *atpos = itemAt(p);

		if (!atpos) // put it at the end
			afterme = lastItem();
		else { // get the one closer to me..
			// That is, the space between two listviewitems
			// Since this aims to be user-friendly :)
			int y = mapFromGlobal(p).y() - mapFromGlobal(itemRect(atpos).topLeft()).y();
			afterme = y < (atpos->height()/2) ? atpos->itemAbove() : atpos;
		}
		p_myFtpView->dropped( e );
	}
}
//-----------------------------------------------
void KBearDirView::slotToggleShowHidden( bool show ){
	if( ! show ) {   // if we should hide all hidden items
		QListViewItem *item = firstChild();
		while ( item ) {
			QListViewItem* i =item;
			item = item->itemBelow();
			if ( i->text( 0 ).left(1) == "." ) // is this a hidden item?
				delete i;                        // if so delete it
		}
	}
}
//-----------------------------------------------
/** Called whenever an item has been deleted */
void KBearDirView::slotDeleteItem( KFileItem* item ){
	QListViewItem *i = firstChild();
	while ( i ) {
		if( ((KBearDirViewItem*) i )->url().path(1) == item->url().path(1) ) {
			delete i;
			return;
		}
		i = i->itemBelow();
	}
}
//-----------------------------------------------
