/***************************************************************************
                          kbear.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 *********************************************************************************/
#include "kbear.h"

//-----------------------------------------------
KBear::KBear()
	:	KBearExtMdiMainFrm( 0 ),
		localFileSysCaption( i18n("Your Local File System" ) ),
		myClipBoard( new KBearClipBoard() )
{
	myConfig =  new KConfig("kbearrc");

	myCaption = IDS_APPNAME;
	myCaption += " - ";
	myCaption += VERSION;
	///////////////////////////////////////////////////////////////////
	// call inits to invoke all other construction parts
	setupActions();
	initLocalFileSys();
	initMenuBar();
	initToolBar();
	initStatusBar();
	transferView = new KBearTransferView( p_mySplitter, "TransferView" );
	p_mySplitter->setResizeMode( transferView, QSplitter::KeepSize );
	// read config file
	readOptions();
	myConfig->setGroup("General Options");
	if( myConfig->readBoolEntry( "First Run", true) )
		slotWelcome();
}
//-----------------------------------------------
KBear::~KBear() {
	delete myClipBoard;
}
//-----------------------------------------------
void KBear::show() {
	setPlainCaption( myCaption );
	KMainWindow::show();
}
//-----------------------------------------------
void KBear::initMenuBar() {
	///////////////////////////////////////////////////////////////////
	// MENUBAR
	///////////////////////////////////////////////////////////////////
	// popup menu for recent connections
	recentFtpMenu = new QPopupMenu( this );
	connect(recentFtpMenu, SIGNAL(activated(int)), SLOT(slotFtpOpenRecent(int)));

	///////////////////////////////////////////////////////////////////
	// menuBar entry FTP
	ftpMenu = new QPopupMenu( this );
	quickConnectAction->plug( ftpMenu );
	disConnectAction->plug( ftpMenu );
	ftpMenu->insertSeparator();
	ftpMenu->insertItem(i18n("Open &Recent..."), recentFtpMenu );
	ftpMenu->insertSeparator();
	clearRecentAction->plug( ftpMenu );
	ftpMenu->insertSeparator();
	siteManagerAction->plug( ftpMenu );
	ftpMenu->insertSeparator();
	quitAction->plug( ftpMenu );

	///////////////////////////////////////////////////////////////////
	// menuBar entry Edit
	editMenu = new QPopupMenu( this );
	cutAction->plug( editMenu );
	copyAction->plug( editMenu );
	pasteAction->plug( editMenu );
	editMenu->insertSeparator();
	findAction->plug( editMenu );
	editMenu->insertSeparator();
	selectAllAction->plug( editMenu );
	clearSelectionAction->plug( editMenu );
	invertSelectionAction->plug( editMenu );

	///////////////////////////////////////////////////////////////////
	// menuBar entry Settings
	settingsMenu=new QPopupMenu(  this );
	toolBarToggleAction->plug( settingsMenu );
	statusBarToggleAction->plug( settingsMenu );
	taskBarToggleAction->plug( settingsMenu );
	transferViewToggleAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	localFileSysToggleAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	settingsAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	wizardAction->plug( settingsMenu );
	///////////////////////////////////////////////////////////////////
	// menuBar entry Help
	myHelpMenu = customHelpMenu();
	
	///////////////////////////////////////////////////////////////////
	// MENUBAR CONFIGURATION
	// set menuBar() the current menuBar

	menuBar()->insertItem(i18n("&FTP"), ftpMenu);
	menuBar()->insertItem(i18n("&Edit"), editMenu);
	menuBar()->insertItem(i18n("&Settings"), settingsMenu);
	menuBar()->insertItem(i18n("&Window"), windowMenu());
	menuBar()->insertItem(i18n("&Help"), myHelpMenu);

	setMenuForSDIModeSysButtons( menuBar() );
///////////////////////////////////////////////////////////////////////
}
//-----------------------------------------------
void KBear::initToolBar() {
	///////////////////////////////////////////////////////////////////
	// TOOLBAR
	toolBar = new KToolBar( this, "MainToolBar");
   toolBar->setBarPos( KToolBar::Top );

	quickConnectAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	disConnectAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	siteManagerAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	cutAction->plug( toolBar );
	copyAction->plug( toolBar );
	pasteAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	findAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	
	// Check if KMail is installed
	QString tmp = KGlobal::dirs()->findResourceDir( "apps", "Internet/KMail.desktop" );
	if( tmp == QString::null )  // No it's not so disable the action
		emailAction->setEnabled( false );
	emailAction->plug( toolBar );
	
	actionSeparator->plug( toolBar );
	browserAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	helpAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	whatsThisAction->plug( toolBar );
}
//-----------------------------------------------
void KBear::initStatusBar() {
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(i18n( "Ready." ) );
}

//-----------------------------------------------
void KBear::slotCreateClient( ConnectInfo& info) {
	KBearExtMdiChildView* w = new KBearFtpView( this, 0L, info.host );
	addWindow( w/*, KBearExtMdi::Detach*/ );
	w->installEventFilter( this );
	w->setMDICaption( info.host );
	QWhatsThis::add(w,i18n("This Window displays the remote file system.\n"
  												"You can use this to transfer files and folders to or\n"
  												"from your local file system by drag and drop."));
	w->show();
	w->resize(400,300);
	w->setIcon( KApplication::kApplication()->miniIcon() );
	if( info.label != "")
		addRecentFile( info.label );

	((KBearFtpView*)w)->slotConnectRemote( info.host, info.port, info.anonym, info.user, info.pass, info.path );
}
//-----------------------------------------------
void KBear::initLocalFileSys() {
  	localFileSys = new KBearFtpView( this, 0L, localFileSysCaption);
  	addWindow( localFileSys );
	localFileSys->installEventFilter( this );
	localFileSys->setMDICaption( localFileSysCaption );
  	QWhatsThis::add( localFileSys, i18n("This Window displays your local file system.\n"
  															"You can use this to transfer files and folders to or\n"
  															"from a remote host by drag and drop."));
	localFileSys->setIcon( KApplication::kApplication()->miniIcon() );
	((KBearFtpView*)localFileSys)->slotConnectLocal( QDir::homeDirPath() );
	setLocalFileSystemEntry( true );
	localFileSys->resize(400,300);
}
//-----------------------------------------------
bool KBear::eventFilter( QObject* object, QEvent* event ) {
	KBearExtMdiChildView* pView=(KBearExtMdiChildView*)object;
	if( event->type() == QEvent::Close ) {
		QCloseEvent* e=(QCloseEvent*)event;
		if( pView == localFileSys ) {
			e->ignore();
			setLocalFileSystemEntry( false );
			localFileSys->hide();
			m_pTaskBar->removeWinButton( localFileSys );
			return true;
		}
	}
	return QWidget::eventFilter( object, event );    // standard event processing
}
//-----------------------------------------------
bool KBear::queryExit() {
	saveOptions();
	return true;
}
//-----------------------------------------------
bool KBear::queryClose() {
	myConfig->setGroup("General Options");
	if( ! myConfig->readBoolEntry( "Confirm On Exit", true) )
		return true;
	KBearQueryExit* queryExitDlg = new KBearQueryExit( this, "KBearQueryExit");
	queryExitDlg->getNumOfTransfers()->display( i18n("%1").arg(transferView->childCount()));
	bool confirm = myConfig->readBoolEntry( "Confirm On Exit", true);
	queryExitDlg->getAskAgainCheckBox()->setChecked( ! confirm );
	int accept = queryExitDlg->exec();
	confirm = queryExitDlg->getAskAgainCheckBox()->isChecked();
	delete queryExitDlg;
	if ( accept == QDialog::Accepted ) {
		myConfig->writeEntry( "Confirm On Exit", !confirm );
		return true;
	}
	return false;
}
//-----------------------------------------------
void KBear::slotFtpQuickConnect() {
  	statusBar()->message(i18n("Opening new connection..."));
	KBearQuickConnect* quickConnectDlg = new KBearQuickConnect( this,"QuickConnect");
	quickConnectDlg->setCaption(i18n("QuickConnect"));
	connect( quickConnectDlg, SIGNAL( remoteConnect( ConnectInfo& ) ),
					this, SLOT( slotCreateClient( ConnectInfo& ) ) );
  	connect( quickConnectDlg, SIGNAL( saveToSiteManager( SiteInfo& ) ),
					this, SLOT( slotSaveToSiteManager( SiteInfo& ) ) );
  	quickConnectDlg->exec();
  	delete quickConnectDlg;
  	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotFtpSiteManager() {
  	statusBar()->message(i18n("Opening the SiteManager..."));
	KDialogBase dialog( this, "SiteManagerDialog", true, i18n("SiteManager"), 0, KDialogBase::Ok );

	KBearSiteManager* mySiteManager = new KBearSiteManager( &dialog,"SiteManager");
	connect( mySiteManager, SIGNAL( remoteConnect( ConnectInfo& ) ),
					this, SLOT( slotCreateClient( ConnectInfo& ) ) );
	mySiteManager->setConnectEnabled( true );
	dialog.setMainWidget( mySiteManager );
	connect( mySiteManager,SIGNAL( close() ),&dialog,SLOT( slotOk() ) );
	dialog.setInitialSize( QSize(500,500));
	dialog.exec();	
  	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotFtpDisconnect() {
	KBearFtpView* m = (KBearFtpView*)activeWindow();
  	if( m == (KBearFtpView*)localFileSys )
  		KMessageBox::sorry (this, i18n("Sorry, you can't disconnect from your local filesystem ;-)"), i18n("Disconnect..."));
  	else {
		statusBar()->message(i18n("Closing connection..."));
		if( m ) 	{
			m->close();		
  		}
  	}
  	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotFtpQuit()
{
  statusBar()->message(i18n("Exiting application...") );
  ///////////////////////////////////////////////////////////////////
  // exits the Application
	if( queryClose() )
		qApp->exit();
	
	statusBar()->message( i18n("Ready.") );
}
//-----------------------------------------------
void KBear::slotViewToolBar()
{
  statusBar()->message(i18n("Toggle toolbar...") );
  ///////////////////////////////////////////////////////////////////
  // turn toolbar on or off
  if (toolBar->isVisible()) {
    toolBar->hide();
    toolBarToggleAction->setChecked( false );
  }
  else {
    toolBar->show();
    toolBarToggleAction->setChecked( true );
  }
  statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotViewStatusBar() {
  statusBar()->message(i18n("Toggle statusbar...") );
  ///////////////////////////////////////////////////////////////////
  //turn statusbar on or off

  if ( statusBar()->isVisible() )   {
    statusBar()->hide();
    statusBarToggleAction->setChecked( false );
  }
  else   {
    statusBar()->show();
    statusBarToggleAction->setChecked( true );
  }

  statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotViewTaskBar(){
  statusBar()->message(i18n("Toggle taskbar...") );
  ///////////////////////////////////////////////////////////////////
  //turn statusbar on or off

  if (m_pTaskBar->isVisible()) {
    hideViewTaskBar();
    taskBarToggleAction->setChecked( false );  }
  else {
    showViewTaskBar();
    taskBarToggleAction->setChecked( true );  }

  statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotStatusHelpMsg(const QString &text){
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}
//-----------------------------------------------
/**  undocks all view windows (unix-like) */
void KBear::switchToToplevelMode(){
   KBearExtMdiMainFrm::switchToToplevelMode();
}
//-----------------------------------------------
/** docks all view windows (Windows-like) */
void KBear::switchToChildframeMode(){
   KBearExtMdiMainFrm::switchToChildframeMode();
}
//-----------------------------------------------
/** just additionally fits the system menu button position to the menu position */
void KBear::resizeEvent ( QResizeEvent *e) {
   KBearExtMdiMainFrm::resizeEvent( e );
   setSysButtonsAtMenuPosition();
}
//-----------------------------------------------
/** toggles the transfer view */
void KBear::slotViewTransferWindow(){
	statusBar()->message(i18n("Toggle the transfer view..."));
	///////////////////////////////////////////////////////////////////
	//turn TransferView on or off
	if( transferViewToggleAction->isChecked() )
		transferView->show();
	else
		transferView->hide();
	
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
/** toggles the home window */
void KBear::slotLocalFileSys() {
	statusBar()->message(i18n("Toggle the local file system window..."));
	///////////////////////////////////////////////////////////////////
	//turn LocalFileSys on or off
	if( localFileSysToggleAction->isChecked() ) {
		localFileSys->show();
		m_pTaskBar->addWinButton( localFileSys );
	}
	else {
		localFileSys->hide();
		m_pTaskBar->removeWinButton( localFileSys );
	}
	
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::saveOptions() {	
	myConfig->setGroup("General Options");
	myConfig->writeEntry("First Run", false );
	myConfig->writeEntry("Recent Connections", recentConnections );
	bool b_runTimeSettings = myConfig->readBoolEntry( "Run Time Settings", true);
	myConfig->writeEntry( "Run Time Settings", b_runTimeSettings );
//	myConfig->writeEntry( "Auto Resume", KProtocolManager::autoResume() );		
	myConfig->setGroup("View Options");
	myConfig->writeEntry ( "Splitter", p_mySplitter->sizes() );
	if( b_runTimeSettings ) {
		myConfig->writeEntry("Show Local", localFileSysToggleAction->isChecked() );
		myConfig->writeEntry("Show Statusbar", statusBarToggleAction->isChecked() );
		myConfig->writeEntry("Show Taskbar", taskBarToggleAction->isChecked() );
		myConfig->writeEntry("Show Toolbar", toolBarToggleAction->isChecked() );
		myConfig->writeEntry("Show TransferView", transferViewToggleAction->isChecked() );
	}
	((KBearFtpView*)localFileSys)->myOperator()->saveConfig( myConfig, "View Settings" );
	saveMainWindowSettings( myConfig );
	myConfig->sync();
}
//-----------------------------------------------
void KBear::readOptions() {
	applyMainWindowSettings( myConfig );
	myConfig->setGroup("View Settings");
	// geometry settings
	QRect rect(0,0,myConfig->readNumEntry("Width",640),
							myConfig->readNumEntry("Height",520));
	setGeometry( rect );
	
	myConfig->setGroup("General Options");
	recentConnections.setAutoDelete( true );
	
	bool firstRun = myConfig->readBoolEntry( "First Run", true);
	if( firstRun ) {
		toolBar->setBarPos( KToolBar::Top );
		m_pTaskBar->setBarPos( KToolBar::Bottom );
	}
	// initialize the recent file list
	int numOfEntries = myConfig->readListEntry("Recent Connections",recentConnections);
	for (int i=0; i < numOfEntries; i++)
		recentFtpMenu->insertItem(recentConnections.at( i ) );
	
	IDS_STARTPAGE = myConfig->readEntry( "Start Page" , IDS_STARTPAGE );
	
//	KProtocolManager::setAutoResume( myConfig->readBoolEntry( "Auto Resume", false) );		
	
	myConfig->setGroup("View Options");
	
	//splitter geometry
	if( firstRun ) {
		QValueList<int> list;
		list << 212 << 104;
		p_mySplitter->setSizes( list );
	}
	else
		p_mySplitter->setSizes( myConfig-> readIntListEntry( "Splitter" ) );
	
	// local filesystem settings
	bool b_localFileSysCheckBox = myConfig->readBoolEntry("Show Local", true);
	if( !	b_localFileSysCheckBox ) {
		setLocalFileSystemEntry( false );
		localFileSys->hide();
		m_pTaskBar->removeWinButton( localFileSys );
	}	
	// statusbar settings
	bool b_statusBarCheckBox = myConfig->readBoolEntry("Show Statusbar", true);
	statusBarToggleAction->setChecked( b_statusBarCheckBox );
	if( ! b_statusBarCheckBox )
		statusBar()->hide();
	// taskbar settings
	bool b_taskBarCheckBox = myConfig->readBoolEntry("Show Taskbar", true);
	taskBarToggleAction->setChecked( b_taskBarCheckBox );
	if( ! b_taskBarCheckBox )
		hideViewTaskBar();
	
	// toolbar settings
	bool b_toolBarCheckBox = myConfig->readBoolEntry("Show Toolbar", true);
	toolBarToggleAction->setChecked( b_toolBarCheckBox );
	if( ! b_toolBarCheckBox)
		toolBar->hide();
	
	// transferview settings
	bool b_transferViewCheckBox = myConfig->readBoolEntry("Show TransferView", true);
	transferViewToggleAction->setChecked( b_transferViewCheckBox );
	if( ! b_transferViewCheckBox )
		transferView->hide();
}
//-----------------------------------------------
void KBear::slotFtpOpenRecent(int id_) {
	statusBar()->message(i18n("Opening connection..."));
	KBearSiteManager* mySiteManager = new KBearSiteManager( 0,"SiteManager");
	SiteInfo* siteInf = mySiteManager->selectedSite( recentFtpMenu->text( id_ ) );
	if( siteInf )
		slotCreateClient( siteInf->info );
	else {
		KMessageBox::error ( this, i18n("Can't find the site: %1\n"
													"It's probably removed from the SiteManager.\n"
													"It will now also be removed from the list over recent connections").arg(recentFtpMenu->text( id_ ))
									, i18n("Error opening recent...") );
		recentFtpMenu->removeItem( id_ );			
	}
	delete mySiteManager;
	statusBar()->message( i18n("Ready.") );
}
//-----------------------------------------------
void KBear::slotFtpClearRecent() {
	recentFtpMenu->clear();
	recentConnections.clear();
}
//-----------------------------------------------
void KBear::addRecentFile(const QString &file) {
	if(recentConnections.contains(file))
		return; // it's already there

	if( recentConnections.count() >= 10)
		recentConnections.remove(recentConnections.last());
	
	recentConnections.prepend(file);

	recentFtpMenu->clear();

	for ( int i =0 ; i < (int)recentConnections.count(); i++)
		recentFtpMenu->insertItem(recentConnections.at(i));
}
//-----------------------------------------------
void KBear::showAboutApplication () {
	KAboutApplication about( this );
	about.exec();
}
//-----------------------------------------------
/** uncheck the meny entry for local file system */
void KBear::setLocalFileSystemEntry( bool flag ){
	localFileSysToggleAction->setChecked( flag );
}
//-----------------------------------------------
/**  */
void KBear::slotCut(){
	slotCopy();
	if( ! myClipBoard->isEmpty() )
		myClipBoard->setCut( true );
}
//-----------------------------------------------
/**  */
void KBear::slotCopy(){
	KBearFtpView* current = (KBearFtpView*)m_pCurrentWindow;
	QStringList urlList;
	const KFileViewItemList* fileList = current->selectedItems();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for( ; it.current();++it ) {
		urlList.append( (*it)->urlString() );
	}
	if( ! urlList.isEmpty() ) {
		pasteAction->setEnabled( true );
		myClipBoard->setContents( urlList );
		myClipBoard->setCut( false );
	}
}
//-----------------------------------------------
/**  */
void KBear::slotPaste() {
	KBearFtpView* current = (KBearFtpView*)m_pCurrentWindow;
	pasteAction->setEnabled( false );
	if( myClipBoard->isEmpty() )
		return;
	QStringList lst = myClipBoard->clipBoardContents();
	if( myClipBoard->cut() )
		startTransfer( current, lst, true );
	else
		startTransfer( current, lst, false );
	
	myClipBoard->clear();
	myClipBoard->setCut( false );
}
//-----------------------------------------------
/**  */
void KBear::slotFind(){
	KBearSearchDialog myDialog( this, "SearchDialog" );
	if( myDialog.exec() == QDialog::Accepted ){
		bool caseSensitive = myDialog.getCaseSensitiveCheckBox()->isChecked();	
		QString name = myDialog.getSearchEdit()->text();
		((KBearFtpView*)m_pCurrentWindow)->myOperator()->setCurrentItem( name, caseSensitive );
	}
}
//-----------------------------------------------
/** this function is invoced first time the user
starts KBear to setup the app, can also be started from the menu */
void KBear::slotWelcome() {
	KBearWizard myWiz( this, "Wizard" );
	setDialogSettings( myWiz.settingsWidget(), myWiz.mixedSettingsWidget() );
	myWiz.exec();
	changeSettings( myWiz.settingsWidget(), myWiz.mixedSettingsWidget() );	
//	KProtocolManager::reparseConfiguration();
}
//-----------------------------------------------
/**  */
void KBear::slotShowHelp(){
	KApplication::kApplication()->invokeHelp();
}
//-----------------------------------------------
/** open a dialog for setting general application settings */
void KBear::slotSettings(){
	KBearSettingsDialog dialog( this, "SettingsDialog" );
	ViewSettingsWidget* view = dialog.viewSettingsWidget();
	MixedSettingsWidget* mixed = dialog.mixedSettingsWidget();
	setDialogSettings( view, mixed );
	if( dialog.exec() == QDialog::Accepted ) {
		changeSettings( view, mixed );
//		KProtocolManager::reparseConfiguration();
	}
}
//-----------------------------------------------
void KBear::setDialogSettings( ViewSettingsWidget* w, MixedSettingsWidget* m ){
	myConfig->setGroup("View Settings");
	bool viewType = myConfig->readBoolEntry("Show DetailView", true);
	w->detailedViewButton()->setChecked( viewType );
	w->iconViewButton()->setChecked( ! viewType );
	w->treeViewCheckBox()->setChecked( myConfig->readBoolEntry("Show TreeView", true) );
	w->transferViewCheckBox()->setChecked( transferViewToggleAction->isChecked() );
	w->toolBarCheckBox()->setChecked( toolBarToggleAction->isChecked() );
	w->statusBarCheckBox()->setChecked( statusBarToggleAction->isChecked() );
	w->taskBarCheckBox()->setChecked( taskBarToggleAction->isChecked() );
	w->localFileSysCheckBox()->setChecked( localFileSysToggleAction->isChecked() );
	myConfig->setGroup("General Options");
	w->runSettingsCheckBox()->setChecked( myConfig->readBoolEntry( "Run Time Settings", true) );
	m->confirmExitCheckBox()->setChecked( myConfig->readBoolEntry( "Confirm On Exit", true) );
	m->setDefaultWebPage ( IDS_STARTPAGE );
//	m->setAutoResume( myConfig->readBoolEntry( "Auto Resume", false) );
	w->slotViewSelect();
}
//-----------------------------------------------
void KBear::changeSettings( ViewSettingsWidget* w, MixedSettingsWidget* m ){
	emit viewSettingsChanged( w->detailedViewButton()->isChecked(),
													w->iconViewButton()->isChecked(),
													w->treeViewCheckBox()->isChecked() );
													
	if( w->transferViewCheckBox()->isChecked() != transferViewToggleAction->isChecked() )
		transferViewToggleAction->activate();
	if( w->toolBarCheckBox()->isChecked() != toolBarToggleAction->isChecked() )
		toolBarToggleAction->activate();
	if( w->statusBarCheckBox()->isChecked() != statusBarToggleAction->isChecked() )
		statusBarToggleAction->activate();
	if( w->taskBarCheckBox()->isChecked() != taskBarToggleAction->isChecked() )
		taskBarToggleAction->activate();
	if( w->localFileSysCheckBox()->isChecked() != localFileSysToggleAction->isChecked() )
		localFileSysToggleAction->activate();
	myConfig->setGroup("General Options");
	myConfig->writeEntry( "Run Time Settings", w->runSettingsCheckBox()->isChecked() );
	myConfig->writeEntry( "Confirm On Exit", m->confirmExitCheckBox()->isChecked() );
//	myConfig->writeEntry( "Auto Resume", m->autoResume() );
//	KProtocolManager::setAutoResume( m->autoResume() );
	IDS_STARTPAGE = m->defaultWebPage();
	myConfig->writeEntry( "Start Page", IDS_STARTPAGE );
}
//-----------------------------------------------
void KBear::startTransfer( KBearFtpView* view, QStringList& urlList , bool move ){
	KURL dest = view->getCurrentURL();
	KURL source( urlList.first() );
	QString host = i18n( "Local File System" );
	if( source.protocol() == "ftp" )
		host = source.host();
	if( dest.protocol() == "ftp"  ) {
/*
		if( source.protocol() == "ftp" ) {
			if( move )
				KMessageBox::sorry( this, i18n("Sorry, you can't move between remote hosts :-(") );
			else
				KMessageBox::sorry( this, i18n("Sorry, you can't copy between remote hosts :-(") );
			return;
		}
*/
		host = dest.host();
	}
	KURL::List srcList;
	srcList.append( dest );
	KIO::Job* transferJob;
	KBearTransferViewItem* i ;
	for ( QStringList::Iterator it = urlList.begin(); it != urlList.end(); ++it ) {
		if( move ) {
			transferJob = KIO::move( (*it), dest, false );
			i = new KBearTransferViewItem( transferJob, transferView, host/*, source.path(1)+source.fileName()*/ );
		}
		else {
			transferJob = KIO::copy( (*it), dest, false );
			i = new KBearTransferViewItem( transferJob, transferView, host/*, source.path(1)+source.fileName()*/ );
		}
		connect( i, SIGNAL( removeMe( KBearTransferViewItem*)),
								this, SLOT( slotRemoveTransferViewItem(KBearTransferViewItem*)));
		connect( (KIO::Job*)transferJob, SIGNAL( result( KIO::Job*)),
								view->myOperator(), SLOT( rereadDir()));
	}
}
//-----------------------------------------------
void KBear::slotRemoveTransferViewItem( KBearTransferViewItem* i ){
	delete (QListViewItem*)(i->myTreeViewItem());
	delete i;
}
//-----------------------------------------------
void KBear::setupActions(){
	myActionCollection = new KActionCollection( this, "KBearActionCollection" );
	myActionCollection->setInstance( KGlobal::instance() );
	myActionCollection->setHighlightingEnabled( true );
	// first setup the actions
	cutAction = KStdAction::cut( this, SLOT( slotCut() ), myActionCollection, "cut" );
	copyAction = KStdAction::copy( this, SLOT( slotCopy() ), myActionCollection, "copy" );
	pasteAction = KStdAction::paste( this, SLOT( slotPaste() ), myActionCollection, "paste" );
	pasteAction->setEnabled( false );
	findAction = KStdAction::find( this, SLOT( slotFind() ), myActionCollection, "find" );
 	selectAllAction = KStdAction::selectAll ( this, SLOT( slotSelectAll() ), myActionCollection , "select all" );	
	clearSelectionAction = new KAction( i18n("&Clear selection"),0,
						this, SLOT( slotClearSelection() ), myActionCollection, "clear selection" );
	invertSelectionAction = new KAction( i18n("&Invert selection"),0,
						this, SLOT( slotInvertSelection() ), myActionCollection, "invert selection" );
	
	actionSeparator = new KActionSeparator( myActionCollection, "separator" );
	
	quickConnectAction = new KAction( i18n("&Quick Connect"),
						"connect_creating", KStdAccel::key( KStdAccel::New ),
						this, SLOT( slotFtpQuickConnect() ), myActionCollection, "quick connect" );

	disConnectAction = new KAction( i18n("&Close Connection"),
						"connect_no", KStdAccel::key( KStdAccel::Close ),
						this, SLOT( slotFtpDisconnect() ), myActionCollection, "close connection" );

	siteManagerAction = new KAction( i18n("&Open Sitemanager"),
						"contents", KStdAccel::key( KStdAccel::Open ),
						 this, SLOT( slotFtpSiteManager() ), myActionCollection, "sitemanager" );

	clearRecentAction = new KAction( i18n("&Clear Recent..."), 0,
						this, SLOT( slotFtpClearRecent() ), myActionCollection, "clear recent" );

	quitAction = KStdAction::quit( this, SLOT( slotFtpQuit() ), myActionCollection, "quit" );

	toolBarToggleAction = KStdAction::showToolbar ( this, SLOT( slotViewToolBar() ), myActionCollection, "toggle toolbar" );

	statusBarToggleAction = KStdAction::showStatusbar ( this, SLOT( slotViewStatusBar() ), myActionCollection, "toggle statusbar" );
	
	taskBarToggleAction = new KToggleAction( i18n("T&askbar"), 0,
						this, SLOT( slotViewTaskBar() ), myActionCollection, "toggle taskbar" );

	transferViewToggleAction = new KToggleAction( i18n("Transfer &View"), 0,
						this, SLOT( slotViewTransferWindow() ), myActionCollection, "toggle transferview" );

	localFileSysToggleAction = new KToggleAction( i18n("Your &Local Filesystem"), 0,
						this, SLOT( slotLocalFileSys() ), myActionCollection, "toggle local" );

	settingsAction = new KAction( i18n("&General Settings"), 0,
						this, SLOT( slotSettings() ), myActionCollection, "settings" );

	wizardAction = new KAction( i18n("Run &Wizard..."), "wizard",0,
						this, SLOT( slotWelcome() ), myActionCollection, "wizard" );
	
	emailAction = new KAction( i18n("Open KMail"),
						"kmail",0, this, SLOT( slotOpenKMail() ), myActionCollection, "kmail" );
	
	browserAction = new KAction( i18n("Open Konqueror Web Browser"),
						"konqueror",0, this, SLOT( slotOpenBrowser() ), myActionCollection, "konqueror" );
	
	helpAction = KStdAction::help( this, SLOT( slotShowHelp() ), myActionCollection, "help" );

	whatsThisAction = KStdAction::whatsThis( this, SLOT( slotWhatsThis() ), myActionCollection, "whats this" );

// setup tooltips
	quickConnectAction->setToolTip ( i18n("Open a new connection") );
	disConnectAction->setToolTip ( i18n("Close current connection") );
	siteManagerAction->setToolTip ( i18n("Open the Sitemanager") );

// setup status text
	quickConnectAction->setStatusText( i18n("Open a new connection") );
	disConnectAction->setStatusText( i18n("Close current connection") );
	siteManagerAction->setStatusText( i18n("Open the Sitemanager") );
	helpAction->setStatusText( i18n("Open the Sitemanager") );
// setup whats this
	quickConnectAction->setWhatsThis( i18n("Click this button to open a new connection.\n\n"
                  "You can also select the Quick Connect command from the FTP menu.") );
	disConnectAction->setWhatsThis( i18n("Click this button to close current connection.\n\n"
                  "You can also select the Close Connection command from the FTP menu.") );
	siteManagerAction->setWhatsThis( i18n("Click this button to open the Sitemanager.\n\n"
                  "You can also select the Open Sitemanager command from the FTP menu.") );
	emailAction->setWhatsThis( i18n("Click this button to open KMail.") );
	browserAction->setWhatsThis( i18n("Click this button to open Konqueror Web Browser.") );

    // insert them into the actionCollection
	myActionCollection->insert( cutAction );
	myActionCollection->insert( copyAction );
	myActionCollection->insert( pasteAction );
	myActionCollection->insert( findAction );
	myActionCollection->insert( selectAllAction );
	myActionCollection->insert( clearSelectionAction );
	myActionCollection->insert( invertSelectionAction );
	myActionCollection->insert( actionSeparator );
	myActionCollection->insert( quickConnectAction );
	myActionCollection->insert( disConnectAction );
	myActionCollection->insert( siteManagerAction );
	myActionCollection->insert( clearRecentAction );
	myActionCollection->insert( settingsAction );
	myActionCollection->insert( wizardAction );
	myActionCollection->insert( emailAction );
	myActionCollection->insert( browserAction );
	myActionCollection->insert( toolBarToggleAction );
	myActionCollection->insert( statusBarToggleAction );
	myActionCollection->insert( taskBarToggleAction );
	myActionCollection->insert( transferViewToggleAction );
	myActionCollection->insert( localFileSysToggleAction );
}
//-----------------------------------------------
void KBear::slotWhatsThis(){
	QWhatsThis::enterWhatsThisMode();
}
//-----------------------------------------------
QPopupMenu* KBear::taskBarPopup(KBearExtMdiChildView* pWnd,bool bIncludeWindowPopup ) {
	QPopupMenu* menu = KBearExtMdiMainFrm::taskBarPopup( pWnd, bIncludeWindowPopup );
	((KBearFtpView*)pWnd)->myOperator()->actionCollection()->action("separator")->plug( menu );
	((KBearFtpView*)pWnd)->myOperator()->actionCollection()->action("popupMenu")->plug( menu );
	return menu;
}
//-----------------------------------------------
bool KBear::detailedViewIsSet() const {
	return myConfig->readBoolEntry("Show DetailView", true);
}
//-----------------------------------------------
void KBear::slotSelectAll(){
	KBearDirOperator* dirOp = ((KBearFtpView*)m_pCurrentWindow)->myOperator();
	((KFileView*)dirOp->view())->selectAll();
}
//-----------------------------------------------
void KBear::slotClearSelection(){
	KBearDirOperator* dirOp = ((KBearFtpView*)m_pCurrentWindow)->myOperator();
	((KFileView*)dirOp->view())->clearSelection();
}
//-----------------------------------------------
void KBear::slotInvertSelection(){
	KBearDirOperator* dirOp = ((KBearFtpView*)m_pCurrentWindow)->myOperator();
	((KFileView*)dirOp->view())->invertSelection();
}
//-----------------------------------------------
void KBear::slotOpenBrowser() {
	QStringList args;
	args.append("openURL");
	args.append( IDS_STARTPAGE );
	KApplication::kApplication()->kdeinitExec( i18n("kfmclient"), args );
}
//-----------------------------------------------
void KBear::slotOpenKMail() {
	KApplication::kApplication()->kdeinitExec( i18n("kmail") );
}
//-----------------------------------------------
void KBear::slotSaveToSiteManager( SiteInfo& siteInfo ) {
	KBearSiteManager* mySiteManager = new KBearSiteManager( 0,"SiteManager");
	mySiteManager->saveSite( siteInfo );
	delete mySiteManager;
}
//-----------------------------------------------
