/***************************************************************************
                          kbearsitemanagermap.h  -  description
                             -------------------
    Begin                : Fri Aug 25 2000
    Copyright            : (C) 2000 by Bjrn Sahlstrm
    Email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERMAP_H
#define KBEARSITEMANAGERMAP_H
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qmap.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdatastream.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// aplication specific include files
#include "kbearsitemanagerstructs.h"
///////////////////////////////////////////////////////
/** */
typedef QMap<QString, SiteInfo> SiteManagerMap;
/** */
typedef QMapIterator<QString, SiteInfo> SiteManagerMapIterator;
///////////////////////////////////////////////////////

/**
  *This Class holds the entire site database for the @ref KBearSiteManager
  *@short This Class holds the entire site database
	*@author Bjrn Sahlstrm
  */
class KBearSiteManagerMap : public SiteManagerMap {
public: 
	KBearSiteManagerMap();
	~KBearSiteManagerMap();
  						
  /**
  *@return the parent name for the specified key
  */
  QString getParent( const QString& key );
  /**
  *@return a pointer to a @ref SiteInfo struct associated with name, otherwise 0L
  */
  SiteInfo* find( const QString& name );
  /**
  *Sets a new parent for the site
  *@param key is the keyword to search for
  *@param newParent is the name of the new parent
  *@see SiteInfo
  */
  void reparent( const QString& key, const QString& newParent );
};
///////////////////////////////////////////////////////
inline QDataStream& operator>>( QDataStream& s, KBearSiteManagerMap& m) {
	m.clear();
	Q_UINT32 c;
	s >> c;
	for( Q_UINT32 i = 0; i < c; ++i ) {
		QString k;
		SiteInfo t;
		s >> k;
		s >> t;
		m.insert( k, t );
	}
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator<<( QDataStream& s, const KBearSiteManagerMap& m ) {
	s << (Q_UINT32)m.count();
	QMapConstIterator<QString,SiteInfo> it = m.begin();
	for( ; it != m.end(); ++it )
		s << it.key() << it.data();
	return s;
}

#endif
