//----------------------------------------------------------------------------
//    filename             : kbearextmdichildfrmcaption.h
//----------------------------------------------------------------------------
//    Project              : Qt MDI extension
//
//    begin                : 07/1999       by Szymon Stefanek as part of kvirc
//                                         (an IRC application)
//    changes              : 09/1999       by Falk Brettschneider to create an
//                           - 06/2000     stand-alone Qt extension set of
//                                         classes and a Qt-based library
//
//    copyright            : (C) 1999-2000 by Falk Brettschneider
//                                         and
//                                         Szymon Stefanek (stefanek@tin.it)
//    email                :  gigafalk@yahoo.com (Falk Brettschneider)
//----------------------------------------------------------------------------
//  changes for KBear
//  20000820 - Name changed to KBearExtMdi...
//
//----------------------------------------------------------------------------
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU Library General Public License as
//    published by the Free Software Foundation; either version 2 of the
//    License, or (at your option) any later version.
//
//----------------------------------------------------------------------------

#ifndef KBEAREXTMDICAPTION_H_
#define KBEAREXTMDICAPTION_H_

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapp.h>
#include <klocale.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearextmdidefines.h"

class KBearExtMdiChildFrm;

/**
* @short Internal class.
*
* It's the caption bar of a child frame widget.
*/
class KBearExtMdiChildFrmCaption : public QWidget
{
   Q_OBJECT
public:
   /**
   * Constructor
   */
   KBearExtMdiChildFrmCaption(KBearExtMdiChildFrm *parent);
   /**
   * Destructor
   */
   ~KBearExtMdiChildFrmCaption();
   /**
   * Repaint the caption bar in active background colours
   */
   void setActive(bool bActive);
   /**
   * Repaint with a new caption bar title
   */
   void setCaption(const QString& text);
   /**
   * Returns the caption bar height depending on the used font
   */
   int heightHint();
public slots:
   /**
   * Grabs the mouse, a move cursor, sets a move indicator variable to true and keeps the global mouse position in mind
   */
   void slot_moveViaSystemMenu();

protected:
   /**
   * Draws the caption bar and its title using the settings
   */
   virtual void paintEvent(QPaintEvent *e);
   /**
   * The same as @ref KBearExtMdiChildFrmCaption::slot_moveViaSystemMenu
   */
   virtual void mousePressEvent(QMouseEvent *);
   /**
   * Calls maximizePressed of the parent widget (@ref KBearExtMdiChildFrm )
   */
   virtual void mouseDoubleClickEvent(QMouseEvent *);
   /**
   * Restore the normal mouse cursor, set the state variable back to 'not moving'
   */
   virtual void mouseReleaseEvent(QMouseEvent *);
   /**
   * Checks if out of move range of the @ref KBearExtMdiChildArea and calls @ref KBearExtMdiChildFrm::move
   */
   virtual void mouseMoveEvent(QMouseEvent *e);
   /**
   * Computes a new abbreviated string from a given string depending on a given maximum width
   */
   QString abbreviateText(QString origStr, int maxWidth);

// attributes
public:
   /**
   * the title string shown in the caption bar
   */
   QString           m_szCaption;

protected: // Protected attributes
   /**
   * parent widget
   */
   KBearExtMdiChildFrm  *m_pParent;
   /** 
   * state variable indicating whether activated or not activated 
   */
   bool              m_bActive;
   /** 
   * state variable indicating if this is being moved at the moment 
   */
   bool              m_bCanMove;
   /** 
   * the position offset related to its parent widget (internally used for translating mouse move positions 
   */
   QPoint            m_offset;
};

#endif //KBEAREXTMDICAPTION_H_
