/***************************************************************************
                          kmudapi.cpp
                      -------------------
    description          :
    begin                : Thu Jun 1 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmudapi.h"
#include "kmud.h"


KmudAPI::KmudAPI(KmudApp* app)
{
	kmudapp=app;
}

KmudAPI::~KmudAPI()
{
}


KmudApp* KmudAPI::getApp()
{
	return kmudapp;
}

KmudView* KmudAPI::getView()
{
	return kmudapp->getView();
}

KmudDoc* KmudAPI::getDoc()
{
	return kmudapp->getDoc();
}

CTelnet* KmudAPI::getConnection()
{
	return kmudapp->getConnection();
}

CMudLog* KmudAPI::getMudLog()
{
	return kmudapp->getMudLog();
}

CMapWindow* KmudAPI::getMapper()
{
	return kmudapp->getMapper();
}

int KmudAPI::writeToSocket(QString string)
{
	CTelnet *ct;
	ct = getConnection();
	if(!ct || !ct->isConnected()) return -1;
	return ct->sendData(string, string.length());
}


QPopupMenu* KmudAPI::getPluginMenu()
{
	return kmudapp->getPluginMenu();
}

