/***************************************************************************
                          notetreedlg.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: notetreedlg.cpp
	Last generated: Mon Sep 27 20:14:48 1999

 *********************************************************************/

#include "notetreedlg.h"
#include "kaspabase.h"

#define Inherited NoteTreeDlgData

class NoteTreeItem:public QListViewItem {

private:
	NoteTreeItem(const NoteTreeItem&);
	NoteTreeItem& operator=(const NoteTreeItem&);

public:
	NoteTreeItem (NoteTreeItem *parent, Oid o, const char *theText = 0):
		QListViewItem(parent, theText), oid(o) {};
	NoteTreeItem (KListView *parent, Oid o, const char *theText = 0):
		QListViewItem(parent, theText), oid(o) {};
	Oid oid;
};	

NoteTreeDlg::NoteTreeDlg(NoteTitle *n, PublTitle *p, QWidget* parent,	const char* name):	
	Inherited( parent, name )
{
	notes=n;
	publs=p;
	PublTitle *nextpubl;
	linklist->addColumn("Notes");
	linklist->setSorting(-1);
	linklist->setRootIsDecorated(true);
	// For all publications
	for(nextpubl=publs; nextpubl; nextpubl=nextpubl->getNext()) {
		NoteTitle *nextnote;
		// Search first note which belongs to the publ.
		for(nextnote=notes; nextnote&&nextnote->getPublNo()!=nextpubl->getOid(); nextnote=nextnote->getNext());
		if(nextnote) {
			NoteTreeItem *knot=new NoteTreeItem(linklist, InvalidOid, nextpubl->getTitle());
			linklist->insertItem(knot);
			// After inserting the title of the publication, insert the connected notes
			while(nextnote) {
				if(nextnote->getPublNo()==nextpubl->getOid()) {
					new NoteTreeItem(knot, nextnote->getOid(), nextnote->getTitle());
				}
				nextnote=nextnote->getNext();
			}	
		}
	}			

	// Add global notes			
	NoteTitle *nextnote=notes;
	while(nextnote) {
		if(nextnote->getPublNo()==InvalidOid) {
			new NoteTreeItem(linklist, nextnote->getOid(), nextnote->getTitle());
			// linklist->insertItem(item);
		}
		nextnote=nextnote->getNext();
	}
	linklist->geometry();
}


NoteTreeDlg::~NoteTreeDlg()
{
	delete publs;
	delete notes;
}

Oid NoteTreeDlg::getOid() {
	NoteTreeItem *item = dynamic_cast<NoteTreeItem *>(linklist->selectedItem());
	return item?item->oid:InvalidOid;
}









