/***************************************************************************
                          kliste.h  -  description
                             -------------------
    begin                : Die Aug 17 03:44:15 CEST 1999

    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KLISTE_H
#define KLISTE_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// include files for KDE
#include <kapp.h>
#include <kparts/mainwindow.h>
#include <kaccel.h>
#include "resource.h"
#include "sql.h"
#include <qstring.h>
#include "qkaspaevent.h"
#include <ktoolbar.h>
#include <kprocess.h>
#include <qdatetime.h>

 class KaspaWidget;

/**
 * The base class for Kaspaliste application windows. It sets up the main
 * window and reads the config file as well as providing a menubar, toolbar
 * and statusbar.
 * KaspalisteApp reimplements the methods that KMainWindow provides for main window handling and supports
 * full session management as well as keyboard accelerator configuration by using KAccel.
 * @see KMainWindow
 * @see KApplication
 * @see KConfig
 * @see KAccel
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KaspalisteApp : public KParts::MainWindow
{
  Q_OBJECT

private:
	KaspalisteApp(const KaspalisteApp&);
	KaspalisteApp& operator=(const KaspalisteApp&);
	
	
  KAction *actCopy;
	KAction *actCut;
	KAction *actPaste;
	KAction *actClose;
	KAction *actQuit;
	KAction *actCreateBibTex;
	KAction *actExport;
	KAction *actAuthorOverview;
	KAction *actNoteOverview;
	KAction *actPublOverview;
	KAction *actNewAuthor;
	KAction *actNewNote;
	KAction *actNewPublication;
	KAction *actNewPublisher;
	KAction *actSearch;
	KAction *actBuildIndex;
	KAction *actOptionBackground;
	KAction *actOptionSearch;
	KAction *actNewWindow;
	KAction *actToolBar;
	KToggleAction *actStatusBar;
	KAction *actBack;
	KAction *actForward;
	
	KLineEdit *urlline;

public:
  /** construtor of KaspalisteApp, calls all init functions to create the application.
   * @see initMenuBar initToolBar
   */
  KaspalisteApp();
  KaspalisteApp(QKaspaEvent *e);

  ~KaspalisteApp();

 protected:
  virtual bool event(QEvent *e);
  void kaspaConnections(KaspaWidget *w);
	void init();
	void setupView(const QPixmap &pm);
	bool cleanupView();

  /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
   * file
   */ 	
  void saveOptions();
  /** read general Options again and initialize all variables like the recent file list
   */
  void readOptions();
  /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
   * @see KAccel
   */
	void initBackForward();

  //void initKeyAccel();
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
   * @see KApplication#getHelpMenu
   */
  void initAction();
  /** this creates the toolbars.
   */
  void initToolBar();
  /** sets up the statusbar for the main window by initialzing a statuslabel.
   */
  void initStatusBar();

  /** queryClose is called by KMainWindow on each closeEvent of a window. Against the
   * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
   * be saved if Modified; on cancel the closeEvent is rejected.
   * @see KMainWindow#queryClose
   * @see KMainWindow#closeEvent
   */
  virtual bool queryClose();
  /** queryExit is called by KMainWindow when the last window of the application is going to be closed during the closeEvent().
   * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
   * properties.
   * @see KMainWindow#queryExit
   * @see KMainWindow#closeEvent
   */
  virtual bool queryExit();
  /** saves the window properties for each open window during session end to the session config file, including saving the currently
   * opened file by a temporary filename provided by KApplication.
   * @see KMainWindow#saveProperties
   */
  virtual void saveProperties(KConfig* );
  /** reads the session config file and restores the application's state including the last opened files and documents by reading the
   * temporary files saved by saveProperties()
   * @see KMainWindow#readProperties
   */
  virtual void readProperties(KConfig* );

  bool showAuthor(KaspaURL url);
  bool showNote(KaspaURL url);
  bool showAuthorOverview(KaspaURL url, const char *caption=0L);
  bool showNoteOverview(KaspaURL url, const char *caption=0L);
  bool showPublOverview(KaspaURL url, const char *caption=0L);
  bool showPublication(KaspaURL url);
  bool showPart(KaspaURL url);
  bool showPartMemo(KaspaURL url);
  bool showBibliography(KaspaURL url);
	bool showPublisher(KaspaURL url);
	bool showDataView(KaspaURL url);
	bool showEditPartData(KaspaURL url);
	bool showSearch(KaspaURL url);
	bool showParser(KaspaURL url);

	void setupBackForward();

  public slots:
  void slotAuthorOverview();
  void slotNoteOverview();
  void slotPublOverview();
  void slotNewNote();
  void slotNewPublication();
  void slotNewAuthor();
  void slotNewPublisher();
	
  void slotSearch();
  void slotBuildIndex();
	
	void slotCreateBibTex();
	void slotExport();

	void slotNextFocus();
	void slotSetURL(const char *url, bool newwin, const char *caption);
	void slotSetURL(const char *url, bool newwin);	

  /** enables menuentries/toolbar items */
  void slotEnableCommand(int id_);
  /** disables menuentries/toolbar items */
  void slotDisableCommand(int id_);
  void slotEnableCommand(int id_, bool state) { if(state) slotEnableCommand(id_); else slotDisableCommand(id_); }
  /** switch argument for slot selection by menu or toolbar ID */
  // void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
  // void statusCallback(int id_);

  void slotBack();
  void slotForward();

	void slotChooseBackground();
  void slotSearchOptions();
  /** opens author */
  void slotNewWindow();
  /** flushes record to database */
  void slotClose();
  /** print the actual file */
  void slotPrint();
  /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
   * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
   */
  void slotQuit();
  /** put the marked text/object into the clipboard and remove
   *	it from the document
   */
  void slotEditCut();
  /** put the marked text/object into the clipboard
   */
  void slotEditCopy();
  /** paste the clipboard into the document
   */
  void slotEditPaste();
  /** toggles the toolbar
   */
  void slotViewToolBar();
  /** toggles the statusbar
   */
  void slotViewStatusBar();
  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
   * @param text the text that is displayed in the statusbar
   */
  void slotStatusMsg(const char *text);
  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
		* statusbar messages that give information about actions for toolbar icons and menuentries.
		* @param text the text that is displayed in the statusbar
		*/
  void slotStatusHelpMsg(const char *text);

  void slotInvalidGUI();
  void slotWorkingGUI();
  void slotReadOnlyGUI();
  void slotReadWriteGUI();
	void slotSetToolbarURL();

 private:
	int urllined;
	int urltoolbar;


	void setupWallpapers();

  /** the configuration object of the application */
  KConfig* config;
  /** the key accelerator container */
  KAccel* key_accel;

  /** file_menu contains all items of the menubar entry "File" */
  // QPopupMenu *file_menu;
  /** edit_menu contains all items of the menubar entry "Edit" */
  // QPopupMenu *edit_menu;
  /** view_menu contains all items of the menubar entry "View" */
  // QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  // QPopupMenu *help_menu;
  // QPopupMenu *new_menu;
  // QPopupMenu *overv_menu;
  // QPopupMenu *opt_menu;
  // QPopupMenu *search_menu;

  /** view is the main widget which represents your working area. The View
   * class should handle all events of the view widget.  It is kept empty so
   * you can create your view according to your application's needs by
   * changing the view class. */
  KaspaWidget *view;
  QList<QKaspaEvent> forward;
  QList<QKaspaEvent> back;
  Sql *conn;
//	KToolBar *maintools;
//	KToolBar *urltools;
	KToolBar *currenttools;
	QMainWindow::ToolBarDock tbdock;

	QPixmap authorbackgr;
	QPixmap partbackgr;
	QPixmap partmemobackgr;
	QPixmap publbackgr;
	QPixmap bibliobackgr;
	QPixmap htmlbackgr;
	QPixmap notebackgr;
	QPixmap selbackgr;
	QPixmap publisherbackgr;
	QPixmap parserbackgr;
	QPixmap searchbackgr;
	QPixmap editpartdatabackgr;

	QString authorbackgrpath;
	QString partbackgrpath;
	QString partmemobackgrpath;
	QString publbackgrpath;
	QString bibliobackgrpath;
	QString htmlbackgrpath;
	QString notebackgrpath;
	QString selbackgrpath;
	QString publisherbackgrpath;
	QString searchbackgrpath;
	QString parserbackgrpath;
	QString editpartdatabackgrpath;

 	int search_checkallxdays;
  int search_wordlimit;
	QStrList search_masks;
	QDate lastcheck;
};

#endif // KLISTE_H
