/***************************************************************************
                          KaspaWidget.cpp  -  description
                             -------------------
    begin                : Thu Sep 2 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qobjcoll.h>
#include <qmessagebox.h>
#include <kmessagebox.h>

#include "kaspawidget.h"
#include "kliste.h"
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <klocale.h>

KaspaWidget::KaspaWidget(QWidget * parent=0, const char * name=0, WFlags f=0 ):
	QWidget(parent, name, f) {  };

KaspaWidget::~KaspaWidget() {
}

void KaspaWidget::closeEvent(QCloseEvent *e) {
	debug("KaspaWidget::closeEvent()\n");
	if(!isWorking() && closeRequest())
		e->accept();
  else
		e->ignore();
}

void KaspaWidget::lockGUI() {
	const QObjectList *list=children();
	
	QObjectListIt it(*list);
	for ( ; it.current(); ++it ) {
		if(it.current()->isWidgetType()) {
			QWidget *w=dynamic_cast<QWidget*>(it.current());
			if(!w) throw(KaspaErr("KaspaWidget::unlockGUI(): Can't cast to QWidget!?!?!?!")); 		
			w->setEnabled(false);
		}
	}
}	

void KaspaWidget::unlockGUI() {
	const QObjectList *list=children();
	
	QObjectListIt it(*list);
	for ( ; it.current(); ++it ) {
		if(it.current()->isWidgetType()) {
			QWidget *w=dynamic_cast<QWidget*>(it.current());
			if(!w) throw(KaspaErr("KaspaWidget::unlockGUI(): Can't cast to QWidget!?!?!?!")); 		
			w->setEnabled(true);
		}
	}
}		


void KaspaWidget::setupGUI() {
  if(!isValid()) {
    setInvalidGUI();
    return;
  }
  if(isReadOnly()) {
    setReadOnlyGUI();
    return;
  }
  if(isWorking()) {
    setWorkingGUI();
    return;
  }
  setReadWriteGUI();
}


bool KaspaWidget::deleteDlg() {
	return KMessageBox::questionYesNo(this, i18n("Delete Record?"), i18n("Delete Rec"));
}

void KaspaWidget::handleWarning(KaspaErr& err) {
	err.print();
	QMessageBox::warning(this, i18n("Warning"), err.error());
	setupGUI();
}

void KaspaWidget::requestAuthor(Oid o, bool w=false) {
	QString s("kaspa://author#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestPublication(Oid o, bool w=false) {
	QString s("kaspa://publication#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestBibliography(Oid o, bool w=false) {
	QString s("kaspa://bibliography#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestNote(Oid o, bool w=false) {
	QString s("kaspa://note#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestPart(Oid o, bool w=false) {
	QString s("kaspa://part#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestPartMemo(Oid o, bool w=false) {
	QString s("kaspa://partmemo#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestPublisher(Oid o, bool w=false) {
	QString s("kaspa://publisher#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}
void KaspaWidget::requestHTMLData(Oid o, bool w=false) {
	QString s("kaspa://partdata#where oid="); s+=QString().setNum(o);
	requestURL(s, w);
}

/**  */
void KaspaWidget::flush(){}

void KaspaWidget::copy() {
	const QObjectList *list=children();
	
	QObjectListIt it(*list);
	for ( ; it.current(); ++it ) {
		if(it.current()->isWidgetType()) {
			QLineEdit *w=dynamic_cast<QLineEdit*>(it.current());
			QMultiLineEdit *m=dynamic_cast<QMultiLineEdit*>(it.current());
			if(w) w->copy();
			if(m) m->copyText();
		}
	}
}

void KaspaWidget::cut() {
	const QObjectList *list=children();
	
	QObjectListIt it(*list);
	for ( ; it.current(); ++it ) {
		if(it.current()->isWidgetType())  {
			QLineEdit *w=dynamic_cast<QLineEdit*>(it.current());
			QMultiLineEdit *m=dynamic_cast<QMultiLineEdit*>(it.current());
			if(w && w->hasFocus()) w->cut();
			if(m && m->hasFocus()) m->cut();
		}
	}
}

void KaspaWidget::paste() {
	const QObjectList *list=children();
	
	QObjectListIt it(*list);
	for ( ; it.current(); ++it ) {
		if(it.current()->isWidgetType()) {
			QLineEdit *w=dynamic_cast<QLineEdit*>(it.current());
			QMultiLineEdit *m=dynamic_cast<QMultiLineEdit*>(it.current());
			if(w && w->hasFocus()) w->paste();
			if(m && m->hasFocus()) m->paste();
		}
	}
}
